/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CopyableIcon;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final String LAF_PREFIX = "/com/intellij/ide/ui/laf/icons/";
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = ContainerUtil.createWeakMap(200);
    @NonNls
    private static final List<IconPathPatcher> ourPatchers = new CopyOnWriteArrayList<IconPathPatcher>();
    public static boolean STRICT;
    private static boolean USE_DARK_ICONS;
    private static ImageFilter IMAGE_FILTER;
    private static volatile int clearCacheCounter;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(0);
        }
        ourPatchers.add(patcher);
        IconLoader.clearCache();
    }

    public static void removePathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(1);
        }
        ourPatchers.remove(patcher);
        IconLoader.clearCache();
    }

    @Deprecated
    @NotNull
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            IconLoader.$$$reportNull$$$0(2);
        }
        JBImageIcon jBImageIcon = new JBImageIcon(image);
        if (jBImageIcon == null) {
            IconLoader.$$$reportNull$$$0(3);
        }
        return jBImageIcon;
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        IconLoader.clearCache();
    }

    public static void setFilter(ImageFilter filter) {
        if (IMAGE_FILTER != filter) {
            IMAGE_FILTER = filter;
            IconLoader.clearCache();
        }
    }

    public static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
        ImageLoader.clearCache();
        ++clearCacheCounter;
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(4);
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(6);
        }
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class callerClass;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(7);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path, boolean strict) {
        Class callerClass;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(8);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass, false, strict);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        Icon icon;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(9);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(10);
        }
        if ((icon = IconLoader.findIcon(path, aClass)) == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class aClass) {
        if (key == null) {
            IconLoader.$$$reportNull$$$0(12);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(13);
        }
        return IconLoader.findLafIcon(key, aClass, STRICT);
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class aClass, boolean strict) {
        if (key == null) {
            IconLoader.$$$reportNull$$$0(14);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(15);
        }
        return IconLoader.findIcon(LAF_PREFIX + key + ".png", aClass, true, strict);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(16);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(17);
        }
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(18);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(19);
        }
        return IconLoader.findIcon(path, aClass, computeNow, STRICT);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow, boolean strict) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(20);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(21);
        }
        String originalPath = path;
        ClassLoader classLoader = aClass.getClassLoader();
        Pair<String, ClassLoader> patchedPath = IconLoader.patchPath(path, classLoader);
        path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        URL myURL = IconLoader.findURL(path, classLoader);
        if (myURL == null) {
            myURL = IconLoader.findURL(path, aClass);
        }
        if (myURL == null) {
            if (strict) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        Icon icon = IconLoader.findIcon(myURL);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = classLoader;
        }
        return icon;
    }

    @NotNull
    private static Pair<String, ClassLoader> patchPath(@NotNull String path, ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(22);
        }
        for (IconPathPatcher patcher : ourPatchers) {
            Class contextClass;
            String newPath = patcher.patchPath(path, classLoader);
            if (newPath == null) {
                newPath = patcher.patchPath(path);
            }
            if (newPath == null) continue;
            LOG.info("replace '" + path + "' with '" + newPath + "'");
            ClassLoader contextClassLoader = patcher.getContextClassLoader(path, classLoader);
            if (contextClassLoader == null && (contextClass = patcher.getContextClass(path)) != null) {
                contextClassLoader = contextClass.getClassLoader();
            }
            Pair<String, ClassLoader> pair = Pair.create(newPath, contextClassLoader);
            if (pair == null) {
                IconLoader.$$$reportNull$$$0(23);
            }
            return pair;
        }
        Pair<String, Object> pair = Pair.create(path, null);
        if (pair == null) {
            IconLoader.$$$reportNull$$$0(24);
        }
        return pair;
    }

    private static boolean isReflectivePath(@NotNull String path) {
        List<String> paths;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(25);
        }
        return (paths = StringUtil.split(path, ".")).size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    private static URL findURL(@NotNull String path, @Nullable Object context) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(26);
        }
        if (context instanceof Class) {
            URL url = ((Class)context).getResource(path);
            if (url != null) {
                return url;
            }
            String alternative = IconLoader.tryAlternativePath(path);
            return alternative == null ? null : ((Class)context).getResource(alternative);
        }
        if (context instanceof ClassLoader) {
            URL url = ((ClassLoader)context).getResource(path = StringUtil.trimStart(path, "/"));
            if (url != null) {
                return url;
            }
            String alternative = IconLoader.tryAlternativePath(path);
            return alternative == null ? null : ((ClassLoader)context).getResource(alternative);
        }
        LOG.warn("unexpected: " + context);
        return null;
    }

    @Nullable
    private static String tryAlternativePath(@NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(27);
        }
        if (path.endsWith(".png")) {
            return path.substring(0, path.length() - 4) + ".svg";
        }
        if (path.endsWith(".svg")) {
            return path.substring(0, path.length() - 4) + ".png";
        }
        LOG.debug("unexpected path: ", path);
        return null;
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url, useCache);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(28);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(29);
        }
        String originalPath = path;
        Pair<String, ClassLoader> patchedPath = IconLoader.patchPath(path, null);
        path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        if (!StringUtil.startsWithChar(path, '/')) {
            return null;
        }
        URL url = IconLoader.findURL(path.substring(1), classLoader);
        Icon icon = IconLoader.findIcon(url);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = classLoader;
        }
        return icon;
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(30);
        }
        return IconLoader.toImage(icon, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Image toImage(@NotNull Icon icon, @Nullable JBUI.ScaleContext ctx) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(31);
        }
        if (icon instanceof RetrievableIcon) {
            icon = ((RetrievableIcon)icon).retrieveIcon();
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon(ctx);
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = GraphicsEnvironment.isHeadless() ? UIUtil.createImage(ctx, (double)icon.getIconWidth(), (double)icon.getIconHeight(), 2, PaintUtil.RoundingMode.FLOOR) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null, _->null; !null, _->!null")
    public static Icon copy(@Nullable Icon icon, @Nullable Component ancestor) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof CopyableIcon) {
            return ((CopyableIcon)icon).copy();
        }
        BufferedImage image = UIUtil.createImage(ancestor, icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon(image);
    }

    @Nullable
    private static ImageIcon checkIcon(Image image, @NotNull URL url) {
        if (url == null) {
            IconLoader.$$$reportNull$$$0(32);
        }
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        assert (icon instanceof ImageIcon);
        return (ImageIcon)icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(33);
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            disabledIcon = IconLoader.filterIcon(icon, UIUtil.getGrayFilter(), null);
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    @Nullable
    public static Icon filterIcon(@NotNull Icon icon, RGBImageFilter filter, @Nullable Component ancestor) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(34);
        }
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error(icon);
            return EMPTY_ICON;
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).createWithFilter(filter);
        } else {
            float scale = icon instanceof JBUI.ScaleContextAware ? (float)((JBUI.ScaleContextAware)((Object)icon)).getScale(JBUI.ScaleType.SYS_SCALE) : (UIUtil.isJreHiDPI() ? JBUI.sysScale(ancestor) : 1.0f);
            BufferedImage image = new BufferedImage((int)(scale * (float)icon.getIconWidth()), (int)(scale * (float)icon.getIconHeight()), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = ImageUtil.filter(image, filter);
            if (UIUtil.isJreHiDPI(ancestor)) {
                img = RetinaImage.createFrom(img, scale, null);
            }
            icon = new JBImageIcon(img);
        }
        return icon;
    }

    @NotNull
    public static Icon getTransparentIcon(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(35);
        }
        Icon icon2 = IconLoader.getTransparentIcon(icon, 0.5f);
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(36);
        }
        return icon2;
    }

    @NotNull
    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(37);
        }
        RetrievableIcon retrievableIcon = new RetrievableIcon(){

            @Override
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
        if (retrievableIcon == null) {
            IconLoader.$$$reportNull$$$0(38);
        }
        return retrievableIcon;
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(39);
        }
        if (icon instanceof CachedImageIcon) {
            ImageIcon imageIcon = ((CachedImageIcon)icon).getRealIcon();
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(40);
            }
            return imageIcon;
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(41);
        }
        return icon2;
    }

    public static Icon getMenuBarIcon(Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = ((RetrievableIcon)icon).retrieveIcon();
        }
        if (icon instanceof MenuBarIconProvider) {
            return ((MenuBarIconProvider)((Object)icon)).getMenuBarIcon(dark);
        }
        return icon;
    }

    public static Icon getDarkIcon(Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof DarkIconProvider) {
            return ((DarkIconProvider)((Object)icon)).getDarkIcon(dark);
        }
        return icon;
    }

    private static Icon getOrigin(RetrievableIcon icon) {
        int level;
        int maxDeep = 10;
        Icon origin = icon.retrieveIcon();
        for (level = 0; origin instanceof RetrievableIcon && level < 10; ++level) {
            origin = ((RetrievableIcon)origin).retrieveIcon();
        }
        if (origin instanceof RetrievableIcon && level >= 10) {
            LOG.error("can't calculate origin icon (too deep in hierarchy), src: " + icon);
        }
        return origin;
    }

    static {
        USE_DARK_ICONS = UIUtil.isUnderDarcula();
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "patchPath";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransparentIcon";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installPathPatcher";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removePathPatcher";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReflectiveIcon";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLafIcon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "patchPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReflectivePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findURL";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryAlternativePath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkIcon";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isGoodSize";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTransparentIcon";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getIconSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static interface DarkIconProvider {
        public Icon getDarkIcon(boolean var1);
    }

    public static interface MenuBarIconProvider {
        public Icon getMenuBarIcon(boolean var1);
    }

    public static abstract class LazyIcon
    extends JBUI.RasterJBIcon
    implements RetrievableIcon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$1000();
        private int numberOfPatchers = IconLoader.access$600().size();
        private ImageFilter filter = IconLoader.access$1100();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon;
            if (this.updateScaleContext(JBUI.ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            if ((icon = this.getOrComputeIcon()) != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS || this.myIcon == null || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size()) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.filter = IMAGE_FILTER;
                this.myWasComputed = true;
                this.numberOfPatchers = ourPatchers.size();
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();

        @Override
        @Nullable
        public Icon retrieveIcon() {
            return this.getOrComputeIcon();
        }

        @Override
        @NotNull
        public Icon copy() {
            Icon icon = IconLoader.copy(this.getOrComputeIcon(), null);
            if (icon == null) {
                LazyIcon.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$LazyIcon", "copy"));
        }
    }

    public static final class CachedImageIcon
    extends JBUI.RasterJBIcon
    implements ScalableIcon,
    DarkIconProvider,
    MenuBarIconProvider {
        private volatile Object myRealIcon;
        @Nullable
        private String myOriginalPath;
        private ClassLoader myClassLoader;
        @NotNull
        private URL myUrl;
        private volatile boolean myDark;
        private volatile boolean myDarkOverridden;
        private volatile int numberOfPatchers;
        private final boolean useCacheOnLoad;
        private int myClearCacheCounter;
        private ImageFilter[] myFilters;
        private final MyScaledIconsCache myScaledIconsCache;

        private CachedImageIcon(@NotNull CachedImageIcon icon) {
            if (icon == null) {
                CachedImageIcon.$$$reportNull$$$0(0);
            }
            this.numberOfPatchers = ourPatchers.size();
            this.myClearCacheCounter = clearCacheCounter;
            this.myScaledIconsCache = new MyScaledIconsCache();
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new JBUI.BaseScaleContext.UpdateListener(){

                @Override
                public void contextUpdated() {
                    CachedImageIcon.this.myRealIcon = null;
                }
            });
            this.myRealIcon = null;
            this.myOriginalPath = icon.myOriginalPath;
            this.myClassLoader = icon.myClassLoader;
            this.myUrl = icon.myUrl;
            this.myDark = icon.myDark;
            this.myDarkOverridden = icon.myDarkOverridden;
            this.numberOfPatchers = icon.numberOfPatchers;
            this.myFilters = icon.myFilters;
            this.useCacheOnLoad = icon.useCacheOnLoad;
            this.myClearCacheCounter = icon.myClearCacheCounter;
        }

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(1);
            }
            this(url, true);
        }

        public CachedImageIcon(@NotNull URL url, boolean useCacheOnLoad) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(2);
            }
            this.numberOfPatchers = ourPatchers.size();
            this.myClearCacheCounter = clearCacheCounter;
            this.myScaledIconsCache = new MyScaledIconsCache();
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new /* invalid duplicate definition of identical inner class */);
            this.myUrl = url;
            this.myDark = USE_DARK_ICONS;
            this.myFilters = new ImageFilter[]{IMAGE_FILTER};
            this.useCacheOnLoad = useCacheOnLoad;
        }

        public String getOriginalPath() {
            return this.myOriginalPath;
        }

        private void setGlobalFilter(ImageFilter globalFilter) {
            this.myFilters[0] = globalFilter;
        }

        private ImageFilter getGlobalFilter() {
            return this.myFilters[0];
        }

        @NotNull
        private synchronized ImageIcon getRealIcon() {
            ImageIcon imageIcon = this.getRealIcon(null);
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(3);
            }
            return imageIcon;
        }

        @Nullable
        public ImageIcon doGetRealIcon() {
            Object icon = this.myRealIcon;
            if (icon instanceof Reference) {
                icon = ((Reference)icon).get();
            }
            return icon instanceof ImageIcon ? (ImageIcon)icon : null;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon(@Nullable JBUI.ScaleContext ctx) {
            Object icon;
            if (!this.isValid()) {
                if (IconLoader.isLoaderDisabled()) {
                    ImageIcon imageIcon = EMPTY_ICON;
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(4);
                    }
                    return imageIcon;
                }
                this.myClearCacheCounter = clearCacheCounter;
                this.myRealIcon = null;
                if (!this.myDarkOverridden) {
                    this.myDark = USE_DARK_ICONS;
                }
                this.setGlobalFilter(IMAGE_FILTER);
                this.myScaledIconsCache.clear();
                if (this.numberOfPatchers != ourPatchers.size()) {
                    this.numberOfPatchers = ourPatchers.size();
                    if (this.myOriginalPath != null) {
                        URL url;
                        String path;
                        Pair patchedPath = IconLoader.patchPath(this.myOriginalPath, this.myClassLoader);
                        String string = path = this.myOriginalPath == null ? null : (String)patchedPath.first;
                        if (patchedPath.second != null) {
                            this.myClassLoader = (ClassLoader)patchedPath.second;
                        }
                        if (this.myClassLoader != null && path != null && path.startsWith("/") && (url = IconLoader.findURL(path = path.substring(1), this.myClassLoader)) != null) {
                            this.myUrl = url;
                        }
                    }
                }
            }
            if (!this.updateScaleContext(ctx) && this.myRealIcon != null) {
                icon = this.myRealIcon;
                if (icon instanceof Reference) {
                    icon = ((Reference)icon).get();
                }
                if (icon instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)icon;
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(5);
                    }
                    return imageIcon;
                }
            }
            if ((icon = this.myScaledIconsCache.getOrScaleIcon(1.0f)) != null) {
                this.myRealIcon = ((ImageIcon)icon).getIconWidth() < 50 && ((ImageIcon)icon).getIconHeight() < 50 ? icon : new SoftReference<Object>(icon);
                Object object = icon;
                if (object == null) {
                    CachedImageIcon.$$$reportNull$$$0(6);
                }
                return object;
            }
            ImageIcon imageIcon = EMPTY_ICON;
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(7);
            }
            return imageIcon;
        }

        private boolean isValid() {
            return !this.myDarkOverridden && this.myDark == USE_DARK_ICONS && this.getGlobalFilter() == IMAGE_FILTER && this.numberOfPatchers == ourPatchers.size() && this.myClearCacheCounter == clearCacheCounter;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            this.getRealIcon(JBUI.ScaleContext.create(c, g2d)).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                CachedImageIcon cachedImageIcon = this;
                if (cachedImageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(8);
                }
                return cachedImageIcon;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(scale);
            if (icon != null) {
                ImageIcon imageIcon = icon;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(9);
                }
                return imageIcon;
            }
            CachedImageIcon cachedImageIcon = this;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(10);
            }
            return cachedImageIcon;
        }

        private synchronized void setDark(boolean dark) {
            this.myDarkOverridden = true;
            if (this.myDark != dark) {
                this.myRealIcon = null;
                this.myClearCacheCounter = -1;
                this.myDark = dark;
            }
        }

        @Override
        public Icon getDarkIcon(boolean isDark) {
            CachedImageIcon newIcon = this.copy();
            newIcon.setDark(isDark);
            return newIcon;
        }

        @Override
        public Icon getMenuBarIcon(boolean isDark) {
            Image img = this.loadFromUrl(JBUI.ScaleContext.createIdentity(), isDark);
            if (img != null) {
                return new ImageIcon(img);
            }
            return this;
        }

        @Override
        @NotNull
        public CachedImageIcon copy() {
            CachedImageIcon cachedImageIcon = new CachedImageIcon(this);
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(11);
            }
            return cachedImageIcon;
        }

        @NotNull
        private Icon createWithFilter(@NotNull RGBImageFilter filter) {
            if (filter == null) {
                CachedImageIcon.$$$reportNull$$$0(12);
            }
            CachedImageIcon icon = new CachedImageIcon(this);
            icon.myFilters = new ImageFilter[]{this.getGlobalFilter(), filter};
            CachedImageIcon cachedImageIcon = icon;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(13);
            }
            return cachedImageIcon;
        }

        private Image loadFromUrl(@NotNull JBUI.ScaleContext ctx, boolean dark) {
            if (ctx == null) {
                CachedImageIcon.$$$reportNull$$$0(14);
            }
            return ImageLoader.loadFromUrl(this.myUrl, true, this.useCacheOnLoad, dark, this.myFilters, ctx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRealIcon";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWithFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithFilter";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFromUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyScaledIconsCache {
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private final Map<Couple<Double>, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new FixedHashMap(5));

            private MyScaledIconsCache() {
            }

            private Couple<Double> key(@NotNull JBUI.ScaleContext ctx) {
                if (ctx == null) {
                    MyScaledIconsCache.$$$reportNull$$$0(0);
                }
                return new Couple<Double>(ctx.getScale(JBUI.ScaleType.USR_SCALE) * ctx.getScale(JBUI.ScaleType.OBJ_SCALE), ctx.getScale(JBUI.ScaleType.SYS_SCALE));
            }

            ImageIcon getOrScaleIcon(float scale) {
                ImageIcon icon;
                JBUI.ScaleContext ctx = (JBUI.ScaleContext)CachedImageIcon.this.getScaleContext();
                if (scale != 1.0f) {
                    ctx = (JBUI.ScaleContext)ctx.copy();
                    ctx.update(JBUI.ScaleType.OBJ_SCALE.of(scale));
                }
                if ((icon = (ImageIcon)SoftReference.dereference(this.scaledIconsCache.get(this.key(ctx)))) != null) {
                    return icon;
                }
                Image image = CachedImageIcon.this.loadFromUrl(ctx, CachedImageIcon.this.myDark);
                icon = IconLoader.checkIcon(image, CachedImageIcon.this.myUrl);
                if (icon != null && (long)(icon.getIconWidth() * icon.getIconHeight() * 4) < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(this.key(ctx), new SoftReference<ImageIcon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/openapi/util/IconLoader$CachedImageIcon$MyScaledIconsCache", "key"));
            }
        }
    }
}

