/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.util.Comparing;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractProperty<T> {
    public static final Comparator<AbstractProperty> NAME_COMPARATOR = (property2, property1) -> property2.getName().compareTo(property1.getName());

    @NonNls
    public abstract String getName();

    public abstract T getDefault(AbstractPropertyContainer var1);

    public abstract T copy(T var1);

    public boolean areEqual(T value1, T value2) {
        return Comparing.equal(value1, value2);
    }

    public T get(AbstractPropertyContainer container) {
        return (T)container.getValueOf(this);
    }

    public void set(AbstractPropertyContainer container, T value) {
        container.setValueOf(this, value);
    }

    public final T cast(Object value) {
        return (T)value;
    }

    public String toString() {
        return this.getName();
    }

    public static abstract class AbstractPropertyContainer<PropertyImpl extends AbstractProperty> {
        public static final AbstractPropertyContainer EMPTY = new AbstractPropertyContainer(){

            public Object getValueOf(AbstractProperty property2) {
                return property2.getDefault(this);
            }

            public void setValueOf(AbstractProperty property2, Object value) {
                throw new UnsupportedOperationException("Property: " + property2.getName() + " value: " + value);
            }

            @Override
            public boolean hasProperty(AbstractProperty property2) {
                return false;
            }
        };

        protected abstract Object getValueOf(PropertyImpl var1);

        protected abstract void setValueOf(PropertyImpl var1, Object var2);

        public abstract boolean hasProperty(AbstractProperty var1);

        protected final <T> void delegateSet(AbstractPropertyContainer container, AbstractProperty<T> property2, T value) {
            container.setValueOf(property2, value);
        }

        protected final <T> T delegateGet(AbstractPropertyContainer container, AbstractProperty<T> property2) {
            return (T)container.getValueOf(property2);
        }

        public final void copyFrom(AbstractPropertyContainer source, AbstractProperty[] properties) {
            for (AbstractProperty property2 : properties) {
                this.setValueOf(property2, source.getValueOf(property2));
            }
        }

        public final boolean areValueEqual(AbstractPropertyContainer other, AbstractProperty[] properties) {
            for (AbstractProperty property2 : properties) {
                if (property2.areEqual(this.getValueOf(property2), other.getValueOf(property2))) continue;
                return false;
            }
            return true;
        }
    }
}

