/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class AnimatedIcon
implements Icon {
    private final Frame[] frames;
    private boolean requested;
    private long time;
    private int index;

    public AnimatedIcon(int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(0);
        }
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        if (frames == null) {
            AnimatedIcon.$$$reportNull$$$0(1);
        }
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.time = System.currentTimeMillis();
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(2);
        }
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i = 0; i < length; ++i) {
            final Icon icon = icons[i];
            assert (icon != null) : "null icon";
            frames[i] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$1", "getIcon"));
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        int next = this.index + 1;
        this.index = next < this.frames.length ? next : 0;
        this.time = current;
    }

    @NotNull
    private Icon getUpdatedIcon() {
        int index2 = this.getCurrentIndex();
        Icon icon = this.frames[index2].getIcon();
        if (icon == null) {
            AnimatedIcon.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private int getCurrentIndex() {
        long current = System.currentTimeMillis();
        Frame frame = this.frames[this.index];
        if ((long)frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.index;
    }

    private void requestRefresh(Component c) {
        if (!this.requested && this.canRefresh(c)) {
            Frame frame = this.frames[this.index];
            int delay = frame.getDelay();
            if (delay > 0) {
                this.requested = true;
                Timer timer = new Timer(delay, event -> {
                    this.requested = false;
                    if (this.canRefresh(c)) {
                        this.doRefresh(c);
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.doRefresh(c);
            }
        }
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getUpdatedIcon();
        this.requestRefresh(c);
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(Component component) {
        return component != null && component.isShowing();
    }

    protected void doRefresh(Component component) {
        if (component != null) {
            component.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AnimatedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AnimatedIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static class Blinking
    extends AnimatedIcon {
        public Blinking(@NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(0);
            }
            this(1000, icon);
        }

        public Blinking(final int delay, final @NotNull Icon icon) {
            if (icon == null) {
                Blinking.$$$reportNull$$$0(1);
            }
            super(new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$Blinking$1", "getIcon"));
                }
            }, new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = (Icon)ObjectUtils.notNull((Object)IconLoader.getDisabledIcon((Icon)icon), (Object)icon);
                    if (icon2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AnimatedIcon$Blinking$2", "getIcon"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AnimatedIcon$Blinking", "<init>"));
        }
    }

    @ApiStatus.Experimental
    public static class FS
    extends AnimatedIcon {
        public static final int DELAY = 50;
        public static final List<Icon> ICONS = Arrays.asList(AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18);

        public FS() {
            super(50, ICONS.toArray(new Icon[0]));
        }
    }

    @Deprecated
    public static class Grey
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = Arrays.asList(AllIcons.Process.State.GreyProgr_1, AllIcons.Process.State.GreyProgr_2, AllIcons.Process.State.GreyProgr_3, AllIcons.Process.State.GreyProgr_4, AllIcons.Process.State.GreyProgr_5, AllIcons.Process.State.GreyProgr_6, AllIcons.Process.State.GreyProgr_7, AllIcons.Process.State.GreyProgr_8);

        public Grey() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Recording
    extends AnimatedIcon {
        public static final int DELAY = 250;
        public static final List<Icon> ICONS = Arrays.asList(AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4);

        public Recording() {
            super(250, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Big
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = Arrays.asList(AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8);

        public Big() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Default
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = Arrays.asList(AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8);

        public Default() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }
}

