/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.PercentEscaper;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.Strftime;

public class SsiProcessingState {
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected static final Escaper urlEscaper = new PercentEscaper(",:-_.*/!~'()", false);
    protected String configErrorMessage;
    protected String configTimeFmt;
    protected String configSizeFmt;
    protected final SsiExternalResolver ssiExternalResolver;
    protected final long lastModifiedDate;
    protected Strftime strftime;
    protected final SsiConditionalState conditionalState;
    private boolean alreadySet;

    public SsiProcessingState(@NotNull SsiExternalResolver ssiExternalResolver, long lastModifiedDate) {
        if (ssiExternalResolver == null) {
            SsiProcessingState.$$$reportNull$$$0(0);
        }
        this.configErrorMessage = DEFAULT_CONFIG_ERR_MSG;
        this.configTimeFmt = DEFAULT_CONFIG_TIME_FMT;
        this.configSizeFmt = DEFAULT_CONFIG_SIZE_FMT;
        this.conditionalState = new SsiConditionalState();
        this.ssiExternalResolver = ssiExternalResolver;
        this.lastModifiedDate = lastModifiedDate;
        this.setConfigTimeFormat(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigTimeFormat(String configTimeFmt, boolean fromConstructor) {
        this.configTimeFmt = configTimeFmt;
        this.strftime = new Strftime(configTimeFmt, Locale.US);
        this.setDateVariables(fromConstructor);
    }

    public String getVariableValue(String variableName) {
        return this.getVariableValue(variableName, "none");
    }

    public String getVariableValue(@NotNull String variableName, String encoding) {
        String variableValue;
        if (variableName == null) {
            SsiProcessingState.$$$reportNull$$$0(1);
        }
        return (variableValue = this.ssiExternalResolver.getVariableValue(variableName)) == null ? null : this.encode(variableValue, encoding);
    }

    public String substituteVariables(String val) {
        int charEnd;
        if (val.indexOf(36) < 0 && val.indexOf(38) < 0) {
            return val;
        }
        val = val.replace("&lt;", "<");
        val = val.replace("&gt;", ">");
        val = val.replace("&quot;", "\"");
        val = val.replace("&amp;", "&");
        StringBuilder sb = new StringBuilder(val);
        int charStart = sb.indexOf("&#");
        while (charStart > -1 && (charEnd = sb.indexOf(";", charStart)) > -1) {
            char c = (char)Integer.parseInt(sb.substring(charStart + 2, charEnd));
            sb.delete(charStart, charEnd + 1);
            sb.insert(charStart, c);
            charStart = sb.indexOf("&#");
        }
        int i = 0;
        while (i < sb.length()) {
            String varName;
            String value;
            while (i < sb.length()) {
                if (sb.charAt(i) == '$') {
                    ++i;
                    break;
                }
                ++i;
            }
            if (i == sb.length()) break;
            if (i > 1 && sb.charAt(i - 2) == '\\') {
                sb.deleteCharAt(i - 2);
                --i;
                continue;
            }
            int nameStart = i;
            int start2 = i - 1;
            char endChar = ' ';
            if (sb.charAt(i) == '{') {
                ++nameStart;
                endChar = '}';
            }
            while (i < sb.length() && sb.charAt(i) != endChar) {
                ++i;
            }
            int end = i;
            int nameEnd = end++;
            if (endChar == '}') {
                // empty if block
            }
            if ((value = this.getVariableValue(varName = sb.substring(nameStart, nameEnd))) == null) {
                value = "";
            }
            sb.replace(start2, end, value);
            i = start2 + value.length();
        }
        return sb.toString();
    }

    protected void setDateVariables(boolean fromConstructor) {
        if (fromConstructor && this.alreadySet) {
            return;
        }
        this.alreadySet = true;
        Date date = new Date();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.ssiExternalResolver.setVariableValue("DATE_GMT", this.formatDate(date, timeZone));
        this.ssiExternalResolver.setVariableValue("DATE_LOCAL", this.formatDate(date, null));
        this.ssiExternalResolver.setVariableValue("LAST_MODIFIED", this.formatDate(new Date(this.lastModifiedDate), null));
    }

    @NotNull
    protected String formatDate(@NotNull Date date, @Nullable TimeZone timeZone) {
        if (date == null) {
            SsiProcessingState.$$$reportNull$$$0(2);
        }
        if (timeZone == null) {
            String string = this.strftime.format(date);
            if (string == null) {
                SsiProcessingState.$$$reportNull$$$0(3);
            }
            return string;
        }
        TimeZone oldTimeZone = this.strftime.getTimeZone();
        this.strftime.setTimeZone(timeZone);
        String retVal = this.strftime.format(date);
        this.strftime.setTimeZone(oldTimeZone);
        String string = retVal;
        if (string == null) {
            SsiProcessingState.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String encode(@NotNull String value, @NotNull String encoding) {
        if (value == null) {
            SsiProcessingState.$$$reportNull$$$0(5);
        }
        if (encoding == null) {
            SsiProcessingState.$$$reportNull$$$0(6);
        }
        if (encoding.equalsIgnoreCase("url")) {
            String string = urlEscaper.escape(value);
            if (string == null) {
                SsiProcessingState.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (encoding.equalsIgnoreCase("none")) {
            String string = value;
            if (string == null) {
                SsiProcessingState.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (encoding.equalsIgnoreCase("entity")) {
            String string = HtmlEscapers.htmlEscaper().escape(value);
            if (string == null) {
                SsiProcessingState.$$$reportNull$$$0(9);
            }
            return string;
        }
        throw new IllegalArgumentException("Unknown encoding: " + encoding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ssiExternalResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/builtInWebServer/ssi/SsiProcessingState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/builtInWebServer/ssi/SsiProcessingState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "encode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SsiConditionalState {
        boolean branchTaken = false;
        int nestingCount = 0;
        boolean processConditionalCommandsOnly = false;

        SsiConditionalState() {
        }
    }
}

