/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.BinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchBaseDirectoryDetector;
import com.intellij.openapi.vcs.changes.patch.ShelvedBinaryFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchPatchPaths {
    private static final int BIG_FILE_BOUND = 100000;
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private boolean myUseProjectRootAsPredefinedBase;

    public MatchPatchPaths(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir();
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2) {
        if (list2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(0);
        }
        return this.execute(list2, false);
    }

    public List<AbstractFilePatchInProgress> execute(@NotNull List<? extends FilePatch> list2, boolean useProjectRootAsPredefinedBase) {
        if (list2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(1);
        }
        PatchBaseDirectoryDetector directoryDetector = PatchBaseDirectoryDetector.getInstance(this.myProject);
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        ArrayList<PatchAndVariants> candidates = new ArrayList<PatchAndVariants>(list2.size());
        ArrayList<FilePatch> newOrWithoutMatches = new ArrayList<FilePatch>();
        this.findCandidates(list2, directoryDetector, candidates, newOrWithoutMatches);
        MultiMap result2 = new MultiMap();
        MatchPatchPaths.filterExactMatches(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        MatchPatchPaths.selectByContextOrByStrip(candidates, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        this.workWithNotExisting(directoryDetector, newOrWithoutMatches, (MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2);
        return new ArrayList<AbstractFilePatchInProgress>(result2.values());
    }

    private void workWithNotExisting(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<FilePatch> newOrWithoutMatches, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (directoryDetector == null) {
            MatchPatchPaths.$$$reportNull$$$0(2);
        }
        if (newOrWithoutMatches == null) {
            MatchPatchPaths.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(4);
        }
        for (FilePatch patch : newOrWithoutMatches) {
            AbstractFilePatchInProgress patchInProgress;
            String afterName = patch.getAfterName();
            String[] strings = MatchPatchPaths.getPathParts(afterName);
            FileBaseMatch best = null;
            boolean bestIsUnique = true;
            for (int i = strings.length - 2; i >= 0; --i) {
                String name = strings[i];
                Collection<VirtualFile> files2 = this.findFilesFromIndex(directoryDetector, name);
                if (files2.isEmpty()) continue;
                for (VirtualFile file2 : files2) {
                    FileBaseMatch match = MatchPatchPaths.compareNamesImpl(strings, file2, i);
                    if (match == null || match.score >= i) continue;
                    if (best == null || this.isBetterMatch(match, best)) {
                        best = match;
                        bestIsUnique = true;
                        continue;
                    }
                    if (match.file.equals(best.file) || this.isBetterMatch(best, match)) continue;
                    bestIsUnique = false;
                }
            }
            if (best != null && bestIsUnique) {
                patchInProgress = MatchPatchPaths.createPatchInProgress(patch, best.file);
                if (patchInProgress == null) break;
                MatchPatchPaths.processStipUp(patchInProgress, best.score);
                result2.putValue((Object)best.file, (Object)patchInProgress);
                continue;
            }
            patchInProgress = MatchPatchPaths.createPatchInProgress(patch, this.myBaseDir);
            if (patchInProgress == null) break;
            result2.putValue((Object)this.myBaseDir, (Object)patchInProgress);
        }
    }

    private boolean isBetterMatch(@NotNull FileBaseMatch match, @NotNull FileBaseMatch best) {
        if (match == null) {
            MatchPatchPaths.$$$reportNull$$$0(5);
        }
        if (best == null) {
            MatchPatchPaths.$$$reportNull$$$0(6);
        }
        return match.score < best.score || match.score == best.score && this.myBaseDir.equals(match.file);
    }

    private static void selectByContextOrByStrip(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (candidates == null) {
            MatchPatchPaths.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(8);
        }
        for (PatchAndVariants candidate : candidates) {
            candidate.findAndAddBestVariant(result2);
        }
    }

    private static void filterExactMatches(@NotNull List<PatchAndVariants> candidates, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
        if (candidates == null) {
            MatchPatchPaths.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(10);
        }
        Iterator<PatchAndVariants> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            PatchAndVariants candidate = iterator.next();
            if (candidate.getVariants().size() == 1) {
                AbstractFilePatchInProgress oneCandidate = candidate.getVariants().get(0);
                result2.putValue((Object)oneCandidate.getBase(), (Object)oneCandidate);
                iterator.remove();
                continue;
            }
            ArrayList<AbstractFilePatchInProgress> exact = new ArrayList<AbstractFilePatchInProgress>(candidate.getVariants().size());
            for (AbstractFilePatchInProgress patch : candidate.getVariants()) {
                if (patch.getCurrentStrip() != 0) continue;
                exact.add(patch);
            }
            if (exact.size() == 1) {
                AbstractFilePatchInProgress patchInProgress = (AbstractFilePatchInProgress)exact.get(0);
                MatchPatchPaths.putSelected(result2, candidate.getVariants(), patchInProgress);
                iterator.remove();
                continue;
            }
            if (exact.isEmpty()) continue;
            candidate.getVariants().retainAll(exact);
        }
    }

    private void findCandidates(@NotNull List<? extends FilePatch> list2, @NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull List<PatchAndVariants> candidates, @NotNull List<FilePatch> newOrWithoutMatches) {
        if (list2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(11);
        }
        if (directoryDetector == null) {
            MatchPatchPaths.$$$reportNull$$$0(12);
        }
        if (candidates == null) {
            MatchPatchPaths.$$$reportNull$$$0(13);
        }
        if (newOrWithoutMatches == null) {
            MatchPatchPaths.$$$reportNull$$$0(14);
        }
        for (FilePatch filePatch : list2) {
            VirtualFile relativeFile;
            String fileName = filePatch.getBeforeFileName();
            if (filePatch.isNewFile() || filePatch.getBeforeName() == null) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(this.findFilesFromIndex(directoryDetector, fileName));
            if (filePatch.getBeforeName() != null && filePatch.getBeforeName().startsWith("..") && (relativeFile = VfsUtil.findRelativeFile((VirtualFile)this.myBaseDir, (String[])MatchPatchPaths.getPathParts(filePatch.getBeforeName()))) != null) {
                files2.add(relativeFile);
            }
            if (files2.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            List variants = ContainerUtil.mapNotNull(files2, file2 -> MatchPatchPaths.processMatch(patch, file2));
            if (variants.isEmpty()) {
                newOrWithoutMatches.add(filePatch);
                continue;
            }
            candidates.add(new PatchAndVariants(variants));
        }
    }

    private Collection<VirtualFile> findFilesFromIndex(@NotNull PatchBaseDirectoryDetector directoryDetector, @NotNull String fileName) {
        if (directoryDetector == null) {
            MatchPatchPaths.$$$reportNull$$$0(15);
        }
        if (fileName == null) {
            MatchPatchPaths.$$$reportNull$$$0(16);
        }
        Collection files2 = (Collection)ReadAction.compute(() -> directoryDetector.findFiles(fileName));
        File shelfResourcesDirectory = ShelveChangesManager.getInstance(this.myProject).getShelfResourcesDirectory();
        return ContainerUtil.filter((Collection)files2, file2 -> !FileUtil.isAncestor((File)shelfResourcesDirectory, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)false));
    }

    private static void putSelected(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2, @NotNull List<AbstractFilePatchInProgress> variants, @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (result2 == null) {
            MatchPatchPaths.$$$reportNull$$$0(17);
        }
        if (variants == null) {
            MatchPatchPaths.$$$reportNull$$$0(18);
        }
        if (patchInProgress == null) {
            MatchPatchPaths.$$$reportNull$$$0(19);
        }
        patchInProgress.setAutoBases(ContainerUtil.mapNotNull(variants, AbstractFilePatchInProgress::getBase));
        result2.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
    }

    private static int getMatchingLines(AbstractFilePatchInProgress<TextFilePatch> patch) {
        String text;
        VirtualFile base = patch.getCurrentBase();
        if (base == null) {
            return -1;
        }
        try {
            text = base.getLength() > 100000L ? VfsUtilCore.loadText((VirtualFile)base, (int)100000) : VfsUtilCore.loadText((VirtualFile)base);
        }
        catch (IOException e) {
            return 0;
        }
        return new GenericPatchApplier(text, patch.getPatch().getHunks()).weightContextMatch(100, 5);
    }

    private boolean isBetterMatch(@NotNull AbstractFilePatchInProgress match, int matchLines, @NotNull AbstractFilePatchInProgress best, int bestLines) {
        if (match == null) {
            MatchPatchPaths.$$$reportNull$$$0(20);
        }
        if (best == null) {
            MatchPatchPaths.$$$reportNull$$$0(21);
        }
        return matchLines > bestLines || matchLines == bestLines && this.myBaseDir.equals(match.getBase());
    }

    private boolean variantMatchedToProjectDir(@NotNull AbstractFilePatchInProgress variant) {
        if (variant == null) {
            MatchPatchPaths.$$$reportNull$$$0(22);
        }
        if (variant.getCurrentStrip() == 0) {
            return this.myBaseDir.equals(variant.getBase());
        }
        int upDirCount = 0;
        VirtualFile base = this.myBaseDir;
        for (String part : MatchPatchPaths.getPathParts(variant.getOriginalBeforePath())) {
            if (!part.equals("..")) break;
            ++upDirCount;
            if (base == null) continue;
            base = base.getParent();
        }
        return upDirCount == variant.getCurrentStrip() && base != null && base.equals(variant.getBase());
    }

    @Nullable
    private static FileBaseMatch compareNames(String beforeName, VirtualFile file2) {
        if (beforeName == null) {
            return null;
        }
        String[] parts = MatchPatchPaths.getPathParts(beforeName);
        return MatchPatchPaths.compareNamesImpl(parts, file2.getParent(), parts.length - 2);
    }

    @NotNull
    private static String[] getPathParts(@Nullable String relativePath) {
        if (relativePath == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                MatchPatchPaths.$$$reportNull$$$0(23);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = relativePath.replace('\\', '/').split("/");
        if (stringArray == null) {
            MatchPatchPaths.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @Nullable
    private static FileBaseMatch compareNamesImpl(String[] parts, VirtualFile parent, int idx) {
        while (parent != null && idx >= 0 && parent.getName().equals(parts[idx])) {
            parent = parent.getParent();
            --idx;
        }
        return parent != null ? new FileBaseMatch(parent, idx + 1) : null;
    }

    @Nullable
    private static AbstractFilePatchInProgress processMatch(FilePatch patch, VirtualFile file2) {
        String beforeName = patch.getBeforeName();
        FileBaseMatch match = MatchPatchPaths.compareNames(beforeName, file2);
        if (match == null) {
            return null;
        }
        AbstractFilePatchInProgress result2 = MatchPatchPaths.createPatchInProgress(patch, match.file);
        if (result2 != null) {
            MatchPatchPaths.processStipUp(result2, match.score);
        }
        return result2;
    }

    @Nullable
    private static AbstractFilePatchInProgress createPatchInProgress(@NotNull FilePatch patch, @NotNull VirtualFile dir) {
        if (patch == null) {
            MatchPatchPaths.$$$reportNull$$$0(25);
        }
        if (dir == null) {
            MatchPatchPaths.$$$reportNull$$$0(26);
        }
        if (patch instanceof TextFilePatch) {
            return new TextFilePatchInProgress((TextFilePatch)patch, null, dir);
        }
        if (patch instanceof ShelvedBinaryFilePatch) {
            return new ShelvedBinaryFilePatchInProgress((ShelvedBinaryFilePatch)patch, null, dir);
        }
        if (patch instanceof BinaryFilePatch) {
            return new BinaryFilePatchInProgress((BinaryFilePatch)patch, null, dir);
        }
        return null;
    }

    private static void processStipUp(AbstractFilePatchInProgress patchInProgress, int num) {
        for (int i = 0; i < num; ++i) {
            patchInProgress.up();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryDetector";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOrWithoutMatches";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "best";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchInProgress";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "workWithNotExisting";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isBetterMatch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectByContextOrByStrip";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterExactMatches";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCandidates";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFilesFromIndex";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putSelected";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "variantMatchedToProjectDir";
                break;
            }
            case 23: 
            case 24: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createPatchInProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileBaseMatch {
        @NotNull
        public final VirtualFile file;
        public final int score;

        FileBaseMatch(@NotNull VirtualFile file2, int score) {
            if (file2 == null) {
                FileBaseMatch.$$$reportNull$$$0(0);
            }
            this.file = file2;
            this.score = score;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$FileBaseMatch", "<init>"));
        }
    }

    private class PatchAndVariants {
        @NotNull
        private final List<AbstractFilePatchInProgress> myVariants;

        private PatchAndVariants(List<AbstractFilePatchInProgress> variants) {
            if (variants == null) {
                PatchAndVariants.$$$reportNull$$$0(0);
            }
            this.myVariants = variants;
        }

        @NotNull
        public List<AbstractFilePatchInProgress> getVariants() {
            List<AbstractFilePatchInProgress> list2 = this.myVariants;
            if (list2 == null) {
                PatchAndVariants.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public void findAndAddBestVariant(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> result2) {
            AbstractFilePatchInProgress first;
            if (result2 == null) {
                PatchAndVariants.$$$reportNull$$$0(2);
            }
            if ((first = (AbstractFilePatchInProgress)ContainerUtil.getFirstItem(this.myVariants)) == null) {
                return;
            }
            AbstractFilePatchInProgress best = null;
            if (first instanceof TextFilePatchInProgress) {
                if (MatchPatchPaths.this.myUseProjectRootAsPredefinedBase) {
                    best = this.findBestByBaseDir();
                }
                if (best == null) {
                    best = this.findBestByText();
                }
            } else {
                best = this.findBestByBaseDir();
                if (best == null) {
                    best = this.findBestByStrip();
                }
            }
            if (best != null) {
                MatchPatchPaths.putSelected((MultiMap<VirtualFile, AbstractFilePatchInProgress>)result2, this.myVariants, best);
            }
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByBaseDir() {
            for (AbstractFilePatchInProgress variant : this.myVariants) {
                if (!MatchPatchPaths.this.variantMatchedToProjectDir(variant)) continue;
                return variant;
            }
            return null;
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByText() {
            TextFilePatchInProgress best = null;
            int bestLines = Integer.MIN_VALUE;
            boolean bestIsUnique = true;
            TextFilePatchInProgress baseDirVariant = null;
            for (AbstractFilePatchInProgress variant : this.myVariants) {
                TextFilePatchInProgress current = (TextFilePatchInProgress)variant;
                int currentLines = MatchPatchPaths.getMatchingLines(current);
                if (best == null || MatchPatchPaths.this.isBetterMatch(current, currentLines, best, bestLines)) {
                    bestLines = currentLines;
                    best = current;
                    bestIsUnique = true;
                } else if (!MatchPatchPaths.this.isBetterMatch(best, bestLines, current, currentLines)) {
                    bestIsUnique = false;
                }
                if (baseDirVariant != null || !MatchPatchPaths.this.myBaseDir.equals(current.getBase())) continue;
                baseDirVariant = current;
            }
            if (!bestIsUnique && baseDirVariant != null) {
                return baseDirVariant;
            }
            return best;
        }

        @Nullable
        private AbstractFilePatchInProgress findBestByStrip() {
            AbstractFilePatchInProgress best = null;
            int bestStrip = Integer.MAX_VALUE;
            for (AbstractFilePatchInProgress current : this.myVariants) {
                int currentStrip = current.getCurrentStrip();
                if (best != null && currentStrip >= bestStrip) continue;
                best = current;
                bestStrip = currentStrip;
            }
            return best;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/MatchPatchPaths$PatchAndVariants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findAndAddBestVariant";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

