/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGuess {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public VcsGuess(@NotNull Project project) {
        if (project == null) {
            VcsGuess.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsGuess.$$$reportNull$$$0(1);
        }
        if (file2.isInLocalFileSystem() && this.isFileInIndex(null, file2)) {
            return this.myVcsManager.getVcsFor(file2);
        }
        return null;
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull FilePath filePath) {
        if (filePath == null) {
            VcsGuess.$$$reportNull$$$0(2);
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)filePath);
        if (validParent != null && this.isFileInIndex(filePath, validParent)) {
            return this.myVcsManager.getVcsFor(validParent);
        }
        return null;
    }

    private boolean isFileInIndex(@Nullable FilePath filePath, @NotNull VirtualFile validParent) {
        if (validParent == null) {
            VcsGuess.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            boolean inContent = this.myVcsManager.isFileInContent(validParent);
            if (inContent) {
                return true;
            }
            if (filePath != null) {
                return VcsGuess.isFileInBaseDir(filePath, this.myProject.getBaseDir()) && !this.myVcsManager.isIgnored(validParent);
            }
            return false;
        });
    }

    private static boolean isFileInBaseDir(@NotNull FilePath filePath, @Nullable VirtualFile baseDir) {
        if (filePath == null) {
            VcsGuess.$$$reportNull$$$0(4);
        }
        VirtualFile parent = filePath.getVirtualFileParent();
        return !filePath.isDirectory() && parent != null && parent.equals(baseDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validParent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsGuess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcsForDirty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInBaseDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

