/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.DarculaMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;

public class DarculaLaf
extends BasicLookAndFeel
implements UserDataHolder {
    private static final Object SYSTEM = new Object();
    public static final String NAME = "Darcula";
    BasicLookAndFeel base;
    protected Disposable myDisposable;
    private Alarm myMnemonicAlarm;
    private final UserDataHolderBase myUserData = new UserDataHolderBase();
    private static boolean myAltPressed;

    protected BasicLookAndFeel createBaseLookAndFeel() {
        try {
            if (SystemInfo.isMac) {
                String name = UIManager.getSystemLookAndFeelClassName();
                return (BasicLookAndFeel)Class.forName(name).newInstance();
            }
            return new IdeaLaf();
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return null;
        }
    }

    private void callInit(String method, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DarculaLaf.$$$reportNull$$$0(0);
        }
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DarculaLaf.$$$reportNull$$$0(1);
        }
        this.myUserData.putUserData(key, value);
    }

    protected static void log(Exception e) {
        e.printStackTrace();
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
            UIDefaults defaults = this.base.getDefaults();
            if (SystemInfo.isLinux) {
                if (!Registry.is((String)"darcula.use.native.fonts.on.linux")) {
                    Font font = DarculaLaf.findFont("DejaVu Sans");
                    if (font != null) {
                        for (Object key : defaults.keySet()) {
                            if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
                            defaults.put(key, new FontUIResource(font.deriveFont(13.0f)));
                        }
                    }
                } else if (Arrays.asList("CN", "JP", "KR", "TW").contains(Locale.getDefault().getCountry())) {
                    for (Object key : defaults.keySet()) {
                        Font font;
                        if (!(key instanceof String) || !((String)key).endsWith(".font") || (font = defaults.getFont(key)) == null) continue;
                        defaults.put(key, new FontUIResource("Dialog", font.getStyle(), font.getSize()));
                    }
                }
            }
            LafManagerImpl.initInputMapDefaults(defaults);
            this.initIdeaDefaults(defaults);
            this.patchStyledEditorKit(defaults);
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            defaults.remove("Spinner.arrowButtonBorder");
            defaults.put("Spinner.arrowButtonSize", JBUI.size((int)16, (int)5).asUIResource());
            MetalLookAndFeel.setCurrentTheme(this.createMetalTheme());
            if (SystemInfo.isWindows && Registry.is((String)"ide.win.frame.decoration")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            if (SystemInfo.isLinux && JBUI.isUsrHiDPI()) {
                DarculaLaf.applySystemFonts(defaults);
            }
            defaults.put("EditorPane.font", defaults.getFont("TextField.font"));
            return defaults;
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return super.getDefaults();
        }
    }

    private static void applySystemFonts(UIDefaults defaults) {
        try {
            String fqn = UIUtil.getSystemLookAndFeelClassName();
            Object systemLookAndFeel = Class.forName(fqn).newInstance();
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults systemDefaults = (UIDefaults)superMethod.invoke(systemLookAndFeel, new Object[0]);
            for (Map.Entry entry : systemDefaults.entrySet()) {
                if (!(entry.getValue() instanceof Font)) continue;
                defaults.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    protected DefaultMetalTheme createMetalTheme() {
        return new DarculaMetalTheme();
    }

    private static Font findFont(String name) {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private void patchStyledEditorKit(UIDefaults defaults) {
        URL url = this.getClass().getResource(this.getPrefix() + (JBUI.isUsrHiDPI() ? "@2x.css" : ".css"));
        StyleSheet styleSheet = UIUtil.loadStyleSheet((URL)url);
        defaults.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        try {
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            AppContext.getAppContext().put(keyField.get(null), UIUtil.loadStyleSheet((URL)url));
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    @NotNull
    protected String getPrefix() {
        if ("darcula" == null) {
            DarculaLaf.$$$reportNull$$$0(2);
        }
        return "darcula";
    }

    @Nullable
    protected String getSystemPrefix() {
        String osSuffix = SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
        return this.getPrefix() + "_" + osSuffix;
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        this.callInit("initComponentDefaults", defaults);
    }

    protected void initIdeaDefaults(UIDefaults defaults) {
        this.loadDefaults(defaults);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "meta C", "copy", "ctrl V", "paste", "meta V", "paste", "ctrl X", "cut", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
    }

    protected void loadDefaults(UIDefaults defaults) {
        Properties properties = new Properties();
        try {
            String darculaKey;
            Object value;
            try (InputStream stream = this.getClass().getResourceAsStream(this.getPrefix() + ".properties");){
                properties.load(stream);
            }
            String systemPrefix = this.getSystemPrefix();
            if (StringUtil.isNotEmpty((String)systemPrefix)) {
                try (InputStream stream = this.getClass().getResourceAsStream(systemPrefix + ".properties");){
                    properties.load(stream);
                }
            }
            HashMap darculaGlobalSettings = new HashMap();
            String prefix = this.getPrefix() + ".";
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith(prefix)) continue;
                value = this.parseValue(key, properties.getProperty(key));
                darculaKey = key.substring(prefix.length());
                if (value == SYSTEM) {
                    darculaGlobalSettings.remove((Object)darculaKey);
                    continue;
                }
                darculaGlobalSettings.put((Object)darculaKey, value);
            }
            for (String key : defaults.keySet()) {
                String s;
                if (!(key instanceof String) || !key.contains(".") || !darculaGlobalSettings.containsKey((Object)(darculaKey = (s = key).substring(s.lastIndexOf(46) + 1)))) continue;
                defaults.put(key, darculaGlobalSettings.get((Object)darculaKey));
            }
            for (String key : properties.stringPropertyNames()) {
                value = properties.getProperty(key);
                defaults.put(key, this.parseValue(key, (String)value));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    protected Object parseValue(String key, @NotNull String value) {
        Icon icon;
        if (value == null) {
            DarculaLaf.$$$reportNull$$$0(3);
        }
        if ("system".equals(value)) {
            return SYSTEM;
        }
        if ((value.endsWith(".png") || value.endsWith(".svg")) && (icon = IconLoader.findIcon((String)value, DarculaLaf.class, (boolean)true)) != null) {
            return icon;
        }
        return UITheme.parseValue(key, value);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "IntelliJ Dark Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        this.myDisposable = Disposer.newDisposable();
        this.base = this.createBaseLookAndFeel();
        try {
            this.base.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Disposer.register((Disposable)application, (Disposable)this.myDisposable);
        }
        this.myMnemonicAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
                myAltPressed = e.getID() == 401;
                this.myMnemonicAlarm.cancelAllRequests();
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner != null) {
                    this.myMnemonicAlarm.addRequest(() -> DarculaLaf.repaintMnemonics(focusOwner, myAltPressed), 10);
                }
            }
            return false;
        }, this.myDisposable);
    }

    public static boolean isAltPressed() {
        return myAltPressed;
    }

    private static void repaintMnemonics(@NotNull Component focusOwner, boolean pressed) {
        if (focusOwner == null) {
            DarculaLaf.$$$reportNull$$$0(4);
        }
        if (pressed != myAltPressed) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(focusOwner);
        if (window != null) {
            for (Component component : window.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                for (JComponent c : UIUtil.findComponentsOfType((JComponent)((JComponent)component), JComponent.class)) {
                    if ((!(c instanceof JLabel) || ((JLabel)c).getDisplayedMnemonicIndex() == -1) && (!(c instanceof AbstractButton) || ((AbstractButton)c).getDisplayedMnemonicIndex() == -1)) continue;
                    c.repaint();
                }
            }
        }
    }

    @Override
    public void uninitialize() {
        try {
            this.base.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Disposer.dispose((Disposable)this.myDisposable);
        this.myDisposable = null;
    }

    @Override
    protected void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/DarculaLaf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/DarculaLaf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "repaintMnemonics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

