/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;

public class StructureViewSelectInTarget
implements SelectInTarget {
    public static final Key<StructureViewWrapper> CUSTOM_STRUCTURE_VIEW_KEY = Key.create((String)"customStructureView");
    private final Project myProject;

    public StructureViewSelectInTarget(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.file.structure", (Object[])new Object[0]);
    }

    public boolean canSelect(SelectInContext context) {
        return context.getFileEditorProvider() != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        FileEditor fileEditor = context.getFileEditorProvider().openFileEditor();
        StructureViewWrapper customStructureView = (StructureViewWrapper)CUSTOM_STRUCTURE_VIEW_KEY.get((UserDataHolder)context.getVirtualFile());
        if (customStructureView != null) {
            customStructureView.selectCurrentElement(fileEditor, context.getVirtualFile(), requestFocus);
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)context.getProject());
        Runnable runnable2 = () -> StructureViewFactoryEx.getInstanceEx(this.myProject).runWhenInitialized(() -> this.getStructureViewWrapper().selectCurrentElement(fileEditor, context.getVirtualFile(), requestFocus));
        if (requestFocus) {
            windowManager.getToolWindow(ToolWindowId.STRUCTURE_VIEW).activate(runnable2);
        } else {
            runnable2.run();
        }
    }

    private StructureViewWrapper getStructureViewWrapper() {
        return StructureViewFactoryEx.getInstanceEx(this.myProject).getStructureViewWrapper();
    }

    public String getToolWindowId() {
        return ToolWindowId.STRUCTURE_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.0f;
    }
}

