/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchReplaceComponent
extends EditorHeaderComponent
implements DataProvider {
    private final EventDispatcher<Listener> myEventDispatcher;
    private final MyTextComponentWrapper mySearchFieldWrapper;
    private JTextComponent mySearchTextComponent;
    private final MyTextComponentWrapper myReplaceFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private final JPanel myLeftPanel;
    private final JPanel myRightPanel;
    private final DefaultActionGroup mySearchFieldActions;
    private final ActionToolbarImpl mySearchActionsToolbar1;
    private final ActionToolbarImpl mySearchActionsToolbar2;
    private final ActionToolbarImpl.PopupStateModifier mySearchToolbar1PopupStateModifier;
    private final DefaultActionGroup myReplaceFieldActions;
    private final ActionToolbarImpl myReplaceActionsToolbar1;
    private final ActionToolbarImpl myReplaceActionsToolbar2;
    private final JPanel myReplaceToolbarWrapper;
    private final Project myProject;
    private final JComponent myTargetComponent;
    private final Runnable myCloseAction;
    private final Runnable myReplaceAction;
    private final DataProvider myDataProviderDelegate;
    private boolean myMultilineMode;
    private String myStatusText;
    private DefaultActionGroup myTouchbarActions;

    @NotNull
    public static Builder buildFor(@Nullable Project project, @NotNull JComponent component) {
        if (component == null) {
            SearchReplaceComponent.$$$reportNull$$$0(0);
        }
        Builder builder2 = new Builder(project, component);
        if (builder2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(1);
        }
        return builder2;
    }

    private SearchReplaceComponent(@Nullable Project project, @NotNull JComponent targetComponent, @NotNull DefaultActionGroup searchToolbar1Actions, final @NotNull BooleanGetter searchToolbar1ModifiedFlagGetter, @NotNull DefaultActionGroup searchToolbar2Actions, @NotNull DefaultActionGroup searchFieldActions, @NotNull DefaultActionGroup replaceToolbar1Actions, @NotNull DefaultActionGroup replaceToolbar2Actions, @NotNull DefaultActionGroup replaceFieldActions, @Nullable Runnable replaceAction, @Nullable Runnable closeAction, @Nullable DataProvider dataProvider) {
        if (targetComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(2);
        }
        if (searchToolbar1Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(3);
        }
        if (searchToolbar1ModifiedFlagGetter == null) {
            SearchReplaceComponent.$$$reportNull$$$0(4);
        }
        if (searchToolbar2Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(5);
        }
        if (searchFieldActions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(6);
        }
        if (replaceToolbar1Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(7);
        }
        if (replaceToolbar2Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(8);
        }
        if (replaceFieldActions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(9);
        }
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myStatusText = "";
        this.myProject = project;
        this.myTargetComponent = targetComponent;
        this.mySearchFieldActions = searchFieldActions;
        this.myReplaceFieldActions = replaceFieldActions;
        this.myReplaceAction = replaceAction;
        this.myCloseAction = closeAction;
        this.mySearchToolbar1PopupStateModifier = new ActionToolbarImpl.PopupStateModifier(){

            @Override
            public int getModifiedPopupState() {
                return -1;
            }

            @Override
            public boolean willModify() {
                return searchToolbar1ModifiedFlagGetter.get();
            }
        };
        this.mySearchFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.mySearchTextComponent = 2.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.myReplaceTextComponent = 3.unwrapTextComponent(wrapped);
            }
        };
        this.myLeftPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myLeftPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.myLeftPanel.add((Component)((Object)this.mySearchFieldWrapper), "North");
        this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "South");
        this.mySearchActionsToolbar1 = this.createSearchToolbar1(searchToolbar1Actions);
        NonOpaquePanel searchToolbarWrapper1 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchToolbarWrapper1.add((Component)this.mySearchActionsToolbar1, (Object)"West");
        this.mySearchActionsToolbar2 = this.createSearchToolbar2(searchToolbar2Actions);
        this.mySearchActionsToolbar2.setForceShowFirstComponent(true);
        Wrapper searchToolbarWrapper2 = new Wrapper((JComponent)this.mySearchActionsToolbar2);
        this.mySearchActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        Wrapper searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout()).setVerticalSizeReferent((JComponent)((Object)this.mySearchFieldWrapper));
        searchPair.add((Component)searchToolbarWrapper1, "West");
        searchPair.add((Component)searchToolbarWrapper2, "Center");
        this.myReplaceActionsToolbar1 = this.createReplaceToolbar1(replaceToolbar1Actions);
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar1).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2 = this.createReplaceToolbar2(replaceToolbar2Actions);
        this.myReplaceActionsToolbar2.setForceShowFirstComponent(true);
        Wrapper replaceToolbarWrapper2 = new Wrapper((JComponent)this.myReplaceActionsToolbar2).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper2, "Center");
        searchToolbarWrapper1.setHorizontalSizeReferent((JComponent)replaceToolbarWrapper1);
        JLabel closeLabel = new JLabel(null, AllIcons.Actions.Cross, 4);
        closeLabel.setBorder(JBUI.Borders.empty((int)5));
        closeLabel.setVerticalAlignment(1);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchReplaceComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        searchPair.add((Component)new Wrapper.North((JComponent)closeLabel), "East");
        this.myRightPanel = new NonOpaquePanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width += JBUI.scale((int)16);
                return size;
            }
        };
        this.myRightPanel.add((Component)searchPair, "North");
        this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.25f);
        this.myRightPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        splitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
        splitter.setOpaque(false);
        splitter.getDivider().setOpaque(false);
        this.add((Component)splitter, "Center");
        this.update("", "", false, false);
        this.myDataProviderDelegate = dataProvider;
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public void resetUndoRedoActions() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceTextComponent);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    public void requestFocusInTheSearchFieldAndSelectContent(Project project) {
        this.mySearchTextComponent.selectAll();
        IdeFocusManager.getInstance((Project)project).requestFocus((Component)this.mySearchTextComponent, true);
        if (this.myReplaceTextComponent != null) {
            this.myReplaceTextComponent.selectAll();
        }
    }

    public void setStatusText(@NotNull String status) {
        if (status == null) {
            SearchReplaceComponent.$$$reportNull$$$0(10);
        }
        this.myStatusText = status;
    }

    @NotNull
    public String getStatusText() {
        String string = this.myStatusText;
        if (string == null) {
            SearchReplaceComponent.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void replace() {
        if (this.myReplaceAction != null) {
            this.myReplaceAction.run();
        }
    }

    public void close() {
        if (this.myCloseAction != null) {
            this.myCloseAction.run();
        }
    }

    public void setRegularBackground() {
        this.mySearchTextComponent.setBackground(UIUtil.getTextFieldBackground());
    }

    public void setNotFoundBackground() {
        this.mySearchTextComponent.setBackground(LightColors.RED);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SearchReplaceComponent.$$$reportNull$$$0(12);
        }
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
            if (this.myTouchbarActions == null) {
                this.myTouchbarActions = new DefaultActionGroup();
                this.myTouchbarActions.add((AnAction)new PrevOccurrenceAction());
                this.myTouchbarActions.add((AnAction)new NextOccurrenceAction());
            }
            return this.myTouchbarActions;
        }
        return this.myDataProviderDelegate != null ? this.myDataProviderDelegate.getData(dataId) : null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(13);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public boolean isMultiline() {
        return this.myMultilineMode;
    }

    private void setMultilineInternal(boolean multiline) {
        boolean stateChanged = multiline != this.myMultilineMode;
        this.myMultilineMode = multiline;
        if (stateChanged) {
            this.multilineStateChanged();
        }
    }

    @NotNull
    public JTextComponent getSearchTextComponent() {
        JTextComponent jTextComponent = this.mySearchTextComponent;
        if (jTextComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(14);
        }
        return jTextComponent;
    }

    @NotNull
    public JTextComponent getReplaceTextComponent() {
        JTextComponent jTextComponent = this.myReplaceTextComponent;
        if (jTextComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(15);
        }
        return jTextComponent;
    }

    private void updateSearchComponent(@NotNull String textToSet) {
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(16);
        }
        if (!this.updateTextComponent(true)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.mySearchTextComponent);
            return;
        }
        this.mySearchTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.searchFieldDocumentChanged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$6", "textChanged"));
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)SearchReplaceComponent.this.mySearchTextComponent.getText())) {
                    SearchReplaceComponent.this.close();
                } else {
                    IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).requestFocus((Component)SearchReplaceComponent.this.myTargetComponent, true);
                    SearchReplaceComponent.this.addTextToRecent(SearchReplaceComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private static void replaceTextInTextComponentEnsuringSelection(@NotNull String textToSet, JTextComponent component) {
        String existingText;
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(17);
        }
        if (!(existingText = component.getText()).equals(textToSet)) {
            component.setText(textToSet);
            if (component.getSelectionStart() == component.getSelectionEnd()) {
                component.selectAll();
            }
        }
    }

    private void updateReplaceComponent(@NotNull String textToSet) {
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(18);
        }
        if (!this.updateTextComponent(false)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.myReplaceTextComponent);
            return;
        }
        this.myReplaceTextComponent.setText(textToSet);
        this.myReplaceTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.replaceFieldDocumentChanged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$8", "textChanged"));
            }
        });
        if (!this.isMultiline()) {
            this.installReplaceOnEnterAction(this.myReplaceTextComponent);
        }
        new VariantsCompletionAction(this.myReplaceTextComponent);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    public void update(@NotNull String findText, @NotNull String replaceText, boolean replaceMode, boolean multiline) {
        if (findText == null) {
            SearchReplaceComponent.$$$reportNull$$$0(19);
        }
        if (replaceText == null) {
            SearchReplaceComponent.$$$reportNull$$$0(20);
        }
        this.setMultilineInternal(multiline);
        boolean needToResetSearchFocus = this.mySearchTextComponent != null && this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent != null && this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent(findText);
        this.updateReplaceComponent(replaceText);
        if (replaceMode) {
            if (this.myReplaceFieldWrapper.getParent() == null) {
                this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "Center");
            }
            if (this.myReplaceToolbarWrapper.getParent() == null) {
                this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
            }
            if (needToResetReplaceFocus) {
                this.myReplaceTextComponent.requestFocusInWindow();
            }
        } else {
            if (this.myReplaceFieldWrapper.getParent() != null) {
                this.myLeftPanel.remove((Component)((Object)this.myReplaceFieldWrapper));
            }
            if (this.myReplaceToolbarWrapper.getParent() != null) {
                this.myRightPanel.remove(this.myReplaceToolbarWrapper);
            }
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.updateBindings();
        this.updateActions();
        this.revalidate();
        this.repaint();
    }

    public void updateActions() {
        this.mySearchActionsToolbar1.updateActionsImmediately();
        this.mySearchActionsToolbar2.updateActionsImmediately();
        this.myReplaceActionsToolbar1.updateActionsImmediately();
        this.myReplaceActionsToolbar2.updateActionsImmediately();
    }

    public void addTextToRecent(@NotNull JTextComponent textField2) {
        String text;
        if (textField2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(21);
        }
        if ((text = textField2.getText()).length() > 0) {
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
            if (textField2 == this.mySearchTextComponent) {
                findInProjectSettings.addStringToFind(text);
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                findInProjectSettings.addStringToReplace(text);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    private boolean updateTextComponent(boolean search2) {
        JTextComponent oldComponent;
        JTextComponent jTextComponent = oldComponent = search2 ? this.mySearchTextComponent : this.myReplaceTextComponent;
        if (oldComponent != null) {
            return false;
        }
        MyTextComponentWrapper wrapper2 = search2 ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        SearchTextArea textArea = new SearchTextArea(search2);
        final JTextArea textComponent = textArea.getTextArea();
        textComponent.setRows(this.isMultiline() ? 2 : 1);
        wrapper2.setContent((JComponent)((Object)textArea));
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
        textComponent.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        textComponent.setBackground(UIUtil.getTextFieldBackground());
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        this.installCloseOnEscapeAction(textComponent);
        return true;
    }

    private void searchFieldDocumentChanged() {
        if (this.mySearchTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.mySearchTextComponent);
        }
        ((Listener)this.myEventDispatcher.getMulticaster()).searchFieldDocumentChanged();
    }

    private void replaceFieldDocumentChanged() {
        if (this.myReplaceTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.myReplaceTextComponent);
        }
        this.myReplaceActionsToolbar2.invalidate();
        this.doLayout();
        ((Listener)this.myEventDispatcher.getMulticaster()).replaceFieldDocumentChanged();
    }

    private void multilineStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).multilineStateChanged();
    }

    private static void adjustRows(@NotNull JTextArea area) {
        if (area == null) {
            SearchReplaceComponent.$$$reportNull$$$0(22);
        }
        area.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)area.getText(), (char)'\n') + 1)));
    }

    private void installCloseOnEscapeAction(@NotNull JTextComponent c) {
        if (c == null) {
            SearchReplaceComponent.$$$reportNull$$$0(23);
        }
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                SearchReplaceComponent.this.close();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$10", "actionPerformed"));
            }
        }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"EditorEscape"), (JComponent)c);
    }

    private void installReplaceOnEnterAction(@NotNull JTextComponent c) {
        if (c == null) {
            SearchReplaceComponent.$$$reportNull$$$0(24);
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.replace();
            }
        };
        c.registerKeyboardAction(action, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void updateBindings() {
        this.updateBindings(this.mySearchFieldActions, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar1, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar2, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.myReplaceFieldActions, (JComponent)((Object)this.myReplaceFieldWrapper));
        this.updateBindings(this.myReplaceActionsToolbar1, (JComponent)this.myReplaceToolbarWrapper);
        this.updateBindings(this.myReplaceActionsToolbar2, (JComponent)this.myReplaceToolbarWrapper);
    }

    private void updateBindings(@NotNull DefaultActionGroup group, @NotNull JComponent shortcutHolder) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(25);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(26);
        }
        this.updateBindings((List<? extends AnAction>)ContainerUtil.immutableList((Object[])group.getChildActionsOrStubs()), shortcutHolder);
    }

    private void updateBindings(@NotNull ActionToolbarImpl toolbar, @NotNull JComponent shortcutHolder) {
        if (toolbar == null) {
            SearchReplaceComponent.$$$reportNull$$$0(27);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(28);
        }
        this.updateBindings(toolbar.getActions(), shortcutHolder);
    }

    private void updateBindings(@NotNull List<? extends AnAction> actions, @NotNull JComponent shortcutHolder) {
        if (actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(29);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(30);
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)this);
        for (AnAction anAction : actions) {
            ShortcutSet shortcut = null;
            if (anAction instanceof ContextAwareShortcutProvider) {
                shortcut = ((ContextAwareShortcutProvider)anAction).getShortcut(context);
            } else if (anAction instanceof ShortcutProvider) {
                shortcut = ((ShortcutProvider)anAction).getShortcut();
            }
            if (shortcut == null) continue;
            anAction.registerCustomShortcutSet(shortcut, shortcutHolder);
        }
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar1(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(31);
        }
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setSecondaryButtonPopupStateModifier(this.mySearchToolbar1PopupStateModifier);
        KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
        if (keyboardShortcut != null) {
            toolbar.setSecondaryActionsTooltip(FindBundle.message("find.popup.show.filter.popup", new Object[0]) + " (" + KeymapUtil.getShortcutText((Shortcut)keyboardShortcut) + ")");
        } else {
            toolbar.setSecondaryActionsTooltip(FindBundle.message("find.popup.show.filter.popup", new Object[0]));
        }
        toolbar.setSecondaryActionsIcon(AllIcons.General.Filter);
        new ShowMoreOptions(toolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(32);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar2(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(33);
        }
        ActionToolbarImpl actionToolbarImpl = this.createToolbar((ActionGroup)group);
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(34);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar1(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(35);
        }
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(36);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar2(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(37);
        }
        ActionToolbarImpl actionToolbarImpl = this.createToolbar((ActionGroup)group);
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(38);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull ActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(39);
        }
        ActionToolbarImpl actionToolbarImpl = this.tweakToolbar((ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true));
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(40);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl tweakToolbar(@NotNull ActionToolbarImpl toolbar) {
        if (toolbar == null) {
            SearchReplaceComponent.$$$reportNull$$$0(41);
        }
        toolbar.setTargetComponent(this);
        toolbar.setLayoutPolicy(2);
        toolbar.setBorder(null);
        Utils.setSmallerFontForChildren(toolbar);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(42);
        }
        return actionToolbarImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/SearchReplaceComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchToolbar1Actions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchToolbar1ModifiedFlagGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchToolbar2Actions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFieldActions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceToolbar1Actions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceToolbar2Actions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceFieldActions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToSet";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutHolder";
                break;
            }
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/SearchReplaceComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchTextComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplaceTextComponent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchToolbar1";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchToolbar2";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplaceToolbar1";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplaceToolbar2";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFor";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setStatusText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateSearchComponent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextInTextComponentEnsuringSelection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateReplaceComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTextToRecent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "adjustRows";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installCloseOnEscapeAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installReplaceOnEnterAction";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateBindings";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createSearchToolbar1";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSearchToolbar2";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceToolbar1";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceToolbar2";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "tweakToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTextComponentWrapper
    extends Wrapper {
        private MyTextComponentWrapper() {
        }

        @Nullable
        public JTextComponent getTextComponent() {
            JComponent wrapped = this.getTargetComponent();
            return wrapped != null ? MyTextComponentWrapper.unwrapTextComponent(wrapped) : null;
        }

        @NotNull
        protected static JTextComponent unwrapTextComponent(@NotNull JComponent wrapped) {
            if (wrapped == null) {
                MyTextComponentWrapper.$$$reportNull$$$0(0);
            }
            if (wrapped instanceof SearchTextField) {
                JBTextField jBTextField = ((SearchTextField)wrapped).getTextEditor();
                if (jBTextField == null) {
                    MyTextComponentWrapper.$$$reportNull$$$0(1);
                }
                return jBTextField;
            }
            if (wrapped instanceof SearchTextArea) {
                JTextArea jTextArea = ((SearchTextArea)((Object)wrapped)).getTextArea();
                if (jTextArea == null) {
                    MyTextComponentWrapper.$$$reportNull$$$0(2);
                }
                return jTextArea;
            }
            throw new AssertionError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapped";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapTextComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapTextComponent";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Builder {
        private final Project myProject;
        private final JComponent myTargetComponent;
        private DataProvider myDataProvider;
        private Runnable myReplaceAction;
        private Runnable myCloseAction;
        private final DefaultActionGroup mySearchActions;
        private final DefaultActionGroup myExtraSearchActions;
        private final DefaultActionGroup mySearchFieldActions;
        private BooleanGetter mySearchToolbarModifiedFlagGetter;
        private final DefaultActionGroup myReplaceActions;
        private final DefaultActionGroup myExtraReplaceActions;
        private final DefaultActionGroup myReplaceFieldActions;

        private Builder(@Nullable Project project, @NotNull JComponent component) {
            if (component == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.mySearchActions = new DefaultActionGroup("search bar 1", false);
            this.myExtraSearchActions = new DefaultActionGroup("search bar 2", false);
            this.mySearchFieldActions = new DefaultActionGroup("search field actions", false);
            this.mySearchToolbarModifiedFlagGetter = BooleanGetter.FALSE;
            this.myReplaceActions = new DefaultActionGroup("replace bar 1", false);
            this.myExtraReplaceActions = new DefaultActionGroup("replace bar 1", false);
            this.myReplaceFieldActions = new DefaultActionGroup("replace field actions", false);
            this.myProject = project;
            this.myTargetComponent = component;
        }

        @NotNull
        public Builder withDataProvider(@NotNull DataProvider provider) {
            if (provider == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myDataProvider = provider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder withReplaceAction(@NotNull Runnable action) {
            if (action == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myReplaceAction = action;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder withCloseAction(@NotNull Runnable action) {
            if (action == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myCloseAction = action;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder addSearchFieldActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.mySearchFieldActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder addReplaceFieldActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myReplaceFieldActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder addPrimarySearchActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.mySearchActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder addSecondarySearchActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(13);
            }
            for (AnAction action : actions) {
                this.mySearchActions.addAction(action).setAsSecondary(true);
            }
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder withSecondarySearchActionsIsModifiedGetter(@NotNull BooleanGetter getter) {
            if (getter == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.mySearchToolbarModifiedFlagGetter = getter;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public Builder addExtraSearchActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.myExtraSearchActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder2;
        }

        @NotNull
        public Builder addPrimaryReplaceActions(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(19);
            }
            this.myReplaceActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder2;
        }

        @NotNull
        public Builder addExtraReplaceAction(AnAction ... actions) {
            if (actions == null) {
                Builder.$$$reportNull$$$0(21);
            }
            this.myExtraReplaceActions.addAll(actions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder2;
        }

        @NotNull
        public SearchReplaceComponent build() {
            SearchReplaceComponent searchReplaceComponent = new SearchReplaceComponent(this.myProject, this.myTargetComponent, this.mySearchActions, this.mySearchToolbarModifiedFlagGetter, this.myExtraSearchActions, this.mySearchFieldActions, this.myReplaceActions, this.myExtraReplaceActions, this.myReplaceFieldActions, this.myReplaceAction, this.myCloseAction, this.myDataProvider);
            if (searchReplaceComponent == null) {
                Builder.$$$reportNull$$$0(23);
            }
            return searchReplaceComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/SearchReplaceComponent$Builder";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 17: 
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/SearchReplaceComponent$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReplaceAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withCloseAction";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addSearchFieldActions";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addReplaceFieldActions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPrimarySearchActions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addSecondarySearchActions";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withSecondarySearchActionsIsModifiedGetter";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addExtraSearchActions";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPrimaryReplaceActions";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addExtraReplaceAction";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withDataProvider";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withReplaceAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withCloseAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addSearchFieldActions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addReplaceFieldActions";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addPrimarySearchActions";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addSecondarySearchActions";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "withSecondarySearchActionsIsModifiedGetter";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraSearchActions";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addPrimaryReplaceActions";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraReplaceAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener
    extends EventListener {
        public void searchFieldDocumentChanged();

        public void replaceFieldDocumentChanged();

        public void multilineStateChanged();
    }
}

