/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsStatusWidget<T extends Repository>
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe {
    protected static final Logger LOG = Logger.getInstance(DvcsStatusWidget.class);
    private static final String MAX_STRING = "VCS: Rebasing feature-12345 in custom development branch";
    @NotNull
    private final String myPrefix;
    @Nullable
    private String myText;
    @Nullable
    private String myTooltip;

    protected DvcsStatusWidget(@NotNull Project project, @NotNull String prefix) {
        if (project == null) {
            DvcsStatusWidget.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            DvcsStatusWidget.$$$reportNull$$$0(1);
        }
        super(project);
        this.myPrefix = prefix;
    }

    @Nullable
    protected abstract T guessCurrentRepository(@NotNull Project var1);

    @NotNull
    protected abstract String getFullBranchName(@NotNull T var1);

    protected abstract boolean isMultiRoot(@NotNull Project var1);

    @NotNull
    protected abstract ListPopup getPopup(@NotNull Project var1, @NotNull T var2);

    protected abstract void subscribeToRepoChangeEvents(@NotNull Project var1);

    protected abstract void rememberRecentRoot(@NotNull String var1);

    public void activate() {
        Project project = this.getProject();
        if (project != null) {
            this.installWidgetToStatusBar(project, this);
        }
    }

    public void deactivate() {
        Project project = this.getProject();
        if (project != null) {
            this.removeWidgetFromStatusBar(project, this);
        }
    }

    @Override
    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    @NotNull
    public String ID() {
        String string = this.getClass().getName();
        if (string == null) {
            DvcsStatusWidget.$$$reportNull$$$0(2);
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            DvcsStatusWidget.$$$reportNull$$$0(3);
        }
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            DvcsStatusWidget.$$$reportNull$$$0(4);
        }
        LOG.debug("selection changed");
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            DvcsStatusWidget.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(6);
        }
        LOG.debug("file opened");
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            DvcsStatusWidget.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            DvcsStatusWidget.$$$reportNull$$$0(8);
        }
        LOG.debug("file closed");
        this.update();
    }

    @Nullable
    public String getSelectedValue() {
        return StringUtil.isEmpty((String)this.myText) ? "" : this.myPrefix + ": " + this.myText;
    }

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public ListPopup getPopupStep() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        T repository = this.guessCurrentRepository(project);
        if (repository == null) {
            return null;
        }
        return this.getPopup(project, repository);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return null;
    }

    protected void updateLater() {
        Project project = this.getProject();
        if (project != null && !project.isDisposed()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                LOG.debug("update after repository change");
                this.update();
            }, project.getDisposed());
        }
    }

    private void update() {
        this.myText = null;
        this.myTooltip = null;
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        T repository = this.guessCurrentRepository(project);
        if (repository == null) {
            return;
        }
        int maxLength = MAX_STRING.length() - 1;
        this.myText = StringUtil.shortenTextWithEllipsis((String)this.getFullBranchName(repository), (int)maxLength, (int)5);
        this.myTooltip = this.getToolTip(project);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
        this.rememberRecentRoot(repository.getRoot().getPath());
    }

    @Nullable
    private String getToolTip(@NotNull Project project) {
        T currentRepository;
        if (project == null) {
            DvcsStatusWidget.$$$reportNull$$$0(9);
        }
        if ((currentRepository = this.guessCurrentRepository(project)) == null) {
            return null;
        }
        String branchName = this.getFullBranchName(currentRepository);
        if (this.isMultiRoot(project)) {
            return branchName + "\nRoot: " + currentRepository.getRoot().getName();
        }
        return branchName;
    }

    private void installWidgetToStatusBar(@NotNull Project project, @NotNull StatusBarWidget widget) {
        if (project == null) {
            DvcsStatusWidget.$$$reportNull$$$0(10);
        }
        if (widget == null) {
            DvcsStatusWidget.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null && !this.isDisposed()) {
                statusBar.addWidget(widget, StatusBar.Anchors.DEFAULT_ANCHOR, (Disposable)project);
                this.subscribeToMappingChanged();
                this.subscribeToRepoChangeEvents(project);
                this.update();
            }
        }, project.getDisposed());
    }

    private void removeWidgetFromStatusBar(@NotNull Project project, @NotNull StatusBarWidget widget) {
        if (project == null) {
            DvcsStatusWidget.$$$reportNull$$$0(12);
        }
        if (widget == null) {
            DvcsStatusWidget.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null && !this.isDisposed()) {
                statusBar.removeWidget(widget.ID());
            }
        }, project.getDisposed());
    }

    private void subscribeToMappingChanged() {
        this.myProject.getMessageBus().connect().subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, (Object)new VcsRepositoryMappingListener(){

            @Override
            public void mappingChanged() {
                LOG.debug("repository mappings changed");
                DvcsStatusWidget.this.updateLater();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/DvcsStatusWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/DvcsStatusWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installWidgetToStatusBar";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeWidgetFromStatusBar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

