/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeWindow {
    private static final Logger LOG = Logger.getInstance(MergeWindow.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeRequest myMergeRequest;
    private MyDialog myWrapper;

    public MergeWindow(@Nullable Project project, @NotNull MergeRequest mergeRequest) {
        if (mergeRequest == null) {
            MergeWindow.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myMergeRequest = mergeRequest;
    }

    protected void init() {
        MergeRequestProcessor processor2 = new MergeRequestProcessor(this.myProject, this.myMergeRequest){

            @Override
            public void closeDialog() {
                MergeWindow.this.myWrapper.doCancelAction();
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(0);
                }
                MergeWindow.this.myWrapper.setTitle(title);
            }

            @Override
            protected void rebuildSouthPanel() {
                MergeWindow.this.myWrapper.rebuildSouthPanel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/merge/MergeWindow$1", "setWindowTitle"));
            }
        };
        this.myWrapper = new MyDialog(processor2);
        this.myWrapper.init();
    }

    public void show() {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Merge dialog should not be shown under a write action, as it will disable any background activity.");
        }
        this.init();
        this.myWrapper.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRequest", "com/intellij/diff/merge/MergeWindow", "<init>"));
    }

    private static class MyPanel
    extends JPanel {
        MyPanel(@NotNull JComponent content) {
            if (content == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)content, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/merge/MergeWindow$MyPanel", "<init>"));
        }
    }

    private static class MyDialog
    extends DialogWrapper {
        @NotNull
        private final MergeRequestProcessor myProcessor;
        @NotNull
        private final Wrapper mySouthPanel;

        MyDialog(@NotNull MergeRequestProcessor processor2) {
            if (processor2 == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            super(processor2.getProject(), true);
            this.mySouthPanel = new Wrapper();
            this.myProcessor = processor2;
        }

        public void init() {
            super.init();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myProcessor);
            this.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    e.getWindow().removeWindowListener(this);
                    myProcessor.init();
                }
            });
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new MyPanel(this.myProcessor.getComponent());
        }

        @Nullable
        protected JComponent createSouthPanel() {
            this.rebuildSouthPanel();
            return this.mySouthPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myProcessor.getPreferredFocusedComponent();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return StringUtil.notNullize((String)((String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY)), (String)"MergeDialog");
        }

        @NotNull
        protected Action[] createActions() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            List actions = ContainerUtil.skipNulls((Collection)ContainerUtil.list((Object[])new Action[]{bottomActions.resolveAction, bottomActions.cancelAction}));
            if (bottomActions.resolveAction != null) {
                bottomActions.resolveAction.putValue("DefaultAction", true);
            }
            Action[] actionArray = (Action[])ArrayUtil.toObjectArray((Collection)actions, Action.class);
            if (actionArray == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        @NotNull
        protected Action[] createLeftSideActions() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            List actions = ContainerUtil.skipNulls((Collection)ContainerUtil.list((Object[])new Action[]{bottomActions.applyLeft, bottomActions.applyRight}));
            Action[] actionArray = (Action[])ArrayUtil.toObjectArray((Collection)actions, Action.class);
            if (actionArray == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        @NotNull
        protected Action getOKAction() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            if (bottomActions.resolveAction != null) {
                Action action = bottomActions.resolveAction;
                if (action == null) {
                    MyDialog.$$$reportNull$$$0(3);
                }
                return action;
            }
            Action action = super.getOKAction();
            if (action == null) {
                MyDialog.$$$reportNull$$$0(4);
            }
            return action;
        }

        @NotNull
        protected Action getCancelAction() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            if (bottomActions.cancelAction != null) {
                Action action = bottomActions.cancelAction;
                if (action == null) {
                    MyDialog.$$$reportNull$$$0(5);
                }
                return action;
            }
            Action action = super.getCancelAction();
            if (action == null) {
                MyDialog.$$$reportNull$$$0(6);
            }
            return action;
        }

        @Nullable
        protected String getHelpId() {
            return this.myProcessor.getHelpId();
        }

        public void doCancelAction() {
            if (!this.myProcessor.checkCloseAction()) {
                return;
            }
            super.doCancelAction();
        }

        public void rebuildSouthPanel() {
            this.mySouthPanel.setContent(super.createSouthPanel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/merge/MergeWindow$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/merge/MergeWindow$MyDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLeftSideActions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOKAction";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCancelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

