/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    public static final ExtensionPointName<DequotingFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionDequotingFilter");

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        String selectedText;
        if (project == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(2);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && !StringUtil.isEmpty((String)(selectedText = selectionModel.getSelectedText()))) {
            TextRange replacedTextRange;
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            if (selectedText.length() > 1) {
                char firstChar = selectedText.charAt(0);
                char lastChar = selectedText.charAt(selectedText.length() - 1);
                if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && selectedText.indexOf(lastChar, 1) == selectedText.length() - 1) {
                    selectedText = selectedText.substring(1, selectedText.length() - 1);
                }
            }
            int caretOffset = selectionModel.getSelectionStart();
            char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
            String newText = c + selectedText + c2;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            boolean restoreStickySelection = editor instanceof EditorEx && ((EditorEx)editor).isStickySelection();
            selectionModel.removeSelection();
            editor.getDocument().replaceString(selectionStart, selectionEnd, (CharSequence)newText);
            TextRange textRange = replacedTextRange = Registry.is((String)"editor.smarterSelectionQuoting") ? new TextRange(caretOffset + 1, caretOffset + newText.length() - 1) : new TextRange(caretOffset, caretOffset + newText.length());
            if (replacedTextRange.getEndOffset() <= editor.getDocument().getTextLength()) {
                if (restoreStickySelection) {
                    EditorEx editorEx = (EditorEx)editor;
                    CaretModel caretModel = editorEx.getCaretModel();
                    caretModel.moveToOffset(ltrSelection ? replacedTextRange.getStartOffset() : replacedTextRange.getEndOffset());
                    editorEx.setStickySelection(true);
                    caretModel.moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                } else {
                    if (ltrSelection || editor instanceof EditorWindow) {
                        editor.getSelectionModel().setSelection(replacedTextRange.getStartOffset(), replacedTextRange.getEndOffset());
                    } else {
                        editor.getSelectionModel().setSelection(replacedTextRange.getEndOffset(), replacedTextRange.getStartOffset());
                    }
                    if (Registry.is((String)"editor.smarterSelectionQuoting")) {
                        editor.getCaretModel().moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                    }
                }
            }
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                SelectionQuotingTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        TypedHandlerDelegate.Result result3 = super.beforeSelectionRemoved(c, project, editor, file2);
        if (result3 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(4);
        }
        return result3;
    }

    private static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor, String selectedText, char c) {
        for (DequotingFilter filter : EP_NAME.getExtensionList()) {
            if (!filter.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c)) continue;
            return true;
        }
        return false;
    }

    private static char getMatchingDelimiter(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '<') {
            return '>';
        }
        return c;
    }

    private static boolean isDelimiter(char c) {
        return SelectionQuotingTypedHandler.isBracket(c) || SelectionQuotingTypedHandler.isQuote(c);
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DequotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

