/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.file.OutOfFileSystemException;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class FileSystem
implements IFileSystem {
    private final File rootDirectory;
    private final String canonicalRootDirectoryName;
    @NonNls
    private static final String OS_NAME_PARAMETER = "os.name";
    @NonNls
    private static final String WINDOWS = "Windows";

    public FileSystem(File rootDirectory) {
        BugLog.getInstance().assertNotNull((Object)rootDirectory);
        this.rootDirectory = rootDirectory;
        this.canonicalRootDirectoryName = FileSystem.getCanonicalFileName(rootDirectory);
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getFile(String relativeFileName) {
        BugLog.getInstance().assertNotNull((Object)relativeFileName);
        return new File(this.rootDirectory, relativeFileName);
    }

    public File getFile(AbstractFileObject fileObject) {
        BugLog.getInstance().assertNotNull((Object)fileObject);
        return new File(this.rootDirectory, fileObject.getPath().substring(1));
    }

    public FileObject getFileObject(File file) throws OutOfFileSystemException {
        BugLog.getInstance().assertNotNull((Object)file);
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file + " isn't a file");
        }
        return FileObject.createInstance((String)this.getPath(file));
    }

    public DirectoryObject getDirectoryObject(File directory) throws OutOfFileSystemException {
        BugLog.getInstance().assertNotNull((Object)directory);
        if (directory.isFile()) {
            throw new IllegalArgumentException(directory + " isn't a directory");
        }
        return DirectoryObject.createInstance((String)this.getPath(directory));
    }

    private String getPath(File file) throws OutOfFileSystemException {
        String canonicalFilePath = FileSystem.getCanonicalFileName(file);
        if (!canonicalFilePath.startsWith(this.canonicalRootDirectoryName)) {
            throw new OutOfFileSystemException(canonicalFilePath, this.canonicalRootDirectoryName);
        }
        String filePath = file.getAbsolutePath();
        int beginIndex = this.canonicalRootDirectoryName.length();
        if (filePath.length() > beginIndex) {
            ++beginIndex;
        }
        return '/' + filePath.substring(beginIndex).replace('\\', '/');
    }

    private static String getCanonicalFileName(File file) {
        String canonicalFileName = file.getAbsolutePath();
        if (canonicalFileName.endsWith(File.separator)) {
            canonicalFileName = canonicalFileName.substring(0, canonicalFileName.length() - 1);
        }
        if (System.getProperty(OS_NAME_PARAMETER).startsWith(WINDOWS)) {
            return canonicalFileName.toLowerCase();
        }
        return canonicalFileName;
    }
}

