/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubNotifications;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0003\u001a\u00020\u0004\"\u000e\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00040\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAsyncUtil;", "", "()V", "awaitFutureAndRunOnEdt", "", "R", "Ljava/util/concurrent/Future;", "T", "future", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "errorTitle", "consumer", "Lkotlin/Function1;", "(Ljava/util/concurrent/Future;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "isCancellation", "", "error", "", "intellij.vcs.github"})
public final class GithubAsyncUtil {
    public static final GithubAsyncUtil INSTANCE;

    @JvmStatic
    public static final <R extends Future<T>, T> void awaitFutureAndRunOnEdt(@NotNull R future, @NotNull Project project, @NotNull String title, @NotNull String errorTitle, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull(future, (String)"future");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)errorTitle, (String)"errorTitle");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        new Task.Backgroundable(future, consumer, project, errorTitle, title, project, title, true, PerformInBackgroundOption.DEAF){
            @Nullable
            private T result;
            final /* synthetic */ Future $future;
            final /* synthetic */ Function1 $consumer;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $errorTitle;
            final /* synthetic */ String $title;

            @Nullable
            public final T getResult() {
                return this.result;
            }

            public final void setResult(@Nullable T t) {
                this.result = t;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                while (true) {
                    try {
                        this.result = this.$future.get(50L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        indicator.checkCanceled();
                        continue;
                    }
                    break;
                }
                indicator.checkCanceled();
            }

            public void onSuccess() {
                block0: {
                    T t = this.result;
                    if (t == null) break block0;
                    T t2 = t;
                    Function1 function1 = this.$consumer;
                    Unit cfr_ignored_0 = (Unit)function1.invoke(t2);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                if (GithubAsyncUtil.INSTANCE.isCancellation(error)) {
                    return;
                }
                GithubNotifications.showError(this.$project, this.$errorTitle, error);
            }
            {
                this.$future = $captured_local_variable$0;
                this.$consumer = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$errorTitle = $captured_local_variable$3;
                this.$title = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        }.queue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCancellation(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if (error instanceof ProcessCanceledException) return true;
        if (error instanceof CancellationException) return true;
        if (error instanceof InterruptedException) return true;
        Throwable throwable = error.getCause();
        if (throwable == null) return false;
        Throwable throwable2 = throwable;
        GithubAsyncUtil githubAsyncUtil = this;
        Throwable p1 = throwable2;
        boolean bl = githubAsyncUtil.isCancellation(p1);
        if (!bl) return false;
        return true;
    }

    private GithubAsyncUtil() {
    }

    static {
        GithubAsyncUtil githubAsyncUtil;
        INSTANCE = githubAsyncUtil = new GithubAsyncUtil();
    }
}

