/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittestLegacy;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.PythonUnitTestTestIdUrlProvider;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonUnitTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonUnitTestRunConfiguration myConfig;

    public PythonUnitTestCommandLineState(PythonUnitTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected PythonHelper getRunner() {
        if (this.myConfig.getTestType() == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT && this.myConfig.getScriptName().endsWith("setup.py")) {
            return PythonHelper.SETUPPY;
        }
        return PythonHelper.UT_OLD;
    }

    @Override
    @NotNull
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String scriptName = FileUtil.toSystemDependentName((String)this.myConfig.getScriptName());
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(scriptName);
                break;
            }
            case TEST_CLASS: {
                specs.add(scriptName + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(scriptName + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                String folderName = FileUtil.toSystemDependentName((String)(this.myConfig.getFolderName() + "/"));
                if (!StringUtil.isEmpty((String)this.myConfig.getPattern()) && this.myConfig.usePattern()) {
                    specs.add(folderName + "_args_separator_" + this.myConfig.getPattern());
                    break;
                }
                specs.add(folderName);
                break;
            }
            case TEST_FUNCTION: {
                specs.add(scriptName + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + (Object)((Object)this.myConfig.getTestType()));
            }
        }
        ArrayList<String> arrayList = specs;
        if (arrayList == null) {
            PythonUnitTestCommandLineState.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected SMTestLocator getTestLocator() {
        return PythonUnitTestTestIdUrlProvider.INSTANCE;
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        if (this.myConfig.useParam() && !StringUtil.isEmptyOrSpaces((String)this.myConfig.getParams())) {
            script_params.addParameter(this.myConfig.getParams());
        }
        if (this.myConfig.getTestType() != AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT || !this.myConfig.getScriptName().endsWith("setup.py")) {
            script_params.addParameter(String.valueOf(this.myConfig.isPureUnittest()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/unittestLegacy/PythonUnitTestCommandLineState", "getTestSpecs"));
    }
}

