/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aH\u0010*\u001a\u0004\u0018\u00010\u00022\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u00022\b\u00101\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u0006\u001a$\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180/2\b\u00104\u001a\u0004\u0018\u00010\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/\u001a$\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180/2\b\u00104\u001a\u0004\u0018\u00010\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/\u001a$\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180/2\b\u00104\u001a\u0004\u0018\u00010\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/\u001a4\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180/2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0006092\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0002\u001a$\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020/2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/2\b\u00104\u001a\u0004\u0018\u00010\u0001\u001a\u001c\u0010;\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020\u00062\b\u0010=\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\n\u0010>\u001a\u00020\u001c*\u00020\u0002\u001a\u001e\u0010?\u001a\u00020@*\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u00012\b\u0010A\u001a\u0004\u0018\u00010\u0006\u001a\u0016\u0010B\u001a\u00020\u001c*\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010C\u001a\u00020D*\u00020\u0002\u001a\u0014\u0010E\u001a\u00020\u001c*\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010F\u001a\u00020\u001c*\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010G\u001a\u00020\u001c*\u00020\u00022\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001a\u0010H\u001a\u0004\u0018\u00010\u0002*\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/\u001a$\u0010I\u001a\u0004\u0018\u00010\u0002*\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\" \u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\b\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020\u001c*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \",\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\",\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010(\"\u0004\b%\u0010)\u00a8\u0006J"}, d2={"associatedModule", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getAssociatedModule", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/intellij/openapi/module/Module;", "associatedModulePath", "", "getAssociatedModulePath", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "associatedPathFromAdditionalData", "getAssociatedPathFromAdditionalData", "associatedPathFromDotProject", "associatedPathFromDotProject$annotations", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "getAssociatedPathFromDotProject", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBaseDir", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "basePath", "getBasePath", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "guessedLanguageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "getGuessedLanguageLevel", "(Lcom/jetbrains/python/sdk/PyDetectedSdk;)Lcom/jetbrains/python/psi/LanguageLevel;", "isNotEmptyDirectory", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "isSystemWide", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "value", "pythonSdk", "getPythonSdk", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/projectRoots/Sdk;", "setPythonSdk", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)V", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "createSdkByGenerateTask", "generateSdkHomePath", "Lcom/intellij/openapi/progress/Task$WithResult;", "Lcom/intellij/execution/ExecutionException;", "existingSdks", "", "baseSdk", "associatedProjectPath", "suggestedSdkName", "detectCondaEnvs", "module", "detectSystemWideSdks", "detectVirtualEnvs", "filterSuggestedPaths", "suggestedPaths", "", "findBaseSdks", "suggestAssociatedSdkName", "sdkHome", "associatedPath", "adminPermissionsNeeded", "associateWithModule", "", "newProjectPath", "containsModuleName", "getOrCreateAdditionalData", "Lcom/jetbrains/python/sdk/PythonSdkAdditionalData;", "isAssociatedWithAnotherModule", "isAssociatedWithModule", "isLocatedInsideModule", "setup", "setupAssociated", "intellij.python.community.impl"})
public final class PySdkExtKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sdk> findBaseSdks(@NotNull List<? extends Sdk> existingSdks, @Nullable Module module2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            if (!(it.getSdkType() instanceof PythonSdkType && PySdkExtKt.isSystemWide(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existing = (List)destination$iv$iv;
        List<PyDetectedSdk> detected = PySdkExtKt.detectSystemWideSdks(module2, existingSdks);
        return CollectionsKt.plus((Collection)existing, (Iterable)detected);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PyDetectedSdk> detectSystemWideSdks(@Nullable Module module2, @NotNull List<? extends Sdk> existingSdks) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<PythonSdkFlavor> list = PythonSdkFlavor.getApplicableFlavors(false);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"PythonSdkFlavor.getApplicableFlavors(false)");
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<PythonSdkFlavor, Sequence<? extends String>>(module2){
            final /* synthetic */ Module $module;

            @NotNull
            public final Sequence<String> invoke(PythonSdkFlavor it) {
                Collection<String> collection = it.suggestHomePaths(this.$module);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"it.suggestHomePaths(module)");
                return CollectionsKt.asSequence((Iterable)collection);
            }
            {
                this.$module = module2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(String it) {
                return !this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set;
                super(1);
            }
        })), (Function1)detectSystemWideSdks.3.INSTANCE);
        Comparator comparator = ComparisonsKt.compareBy((Function1[])new Function1[]{detectSystemWideSdks.4.INSTANCE, detectSystemWideSdks.5.INSTANCE}).reversed();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"compareBy<PyDetectedSdk>\u2026it.homePath }).reversed()");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator));
    }

    @NotNull
    public static final List<PyDetectedSdk> detectVirtualEnvs(@Nullable Module module2, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Collection<String> collection = VirtualEnvSdkFlavor.INSTANCE.suggestHomePaths(module2);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"VirtualEnvSdkFlavor.INST\u2026.suggestHomePaths(module)");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, module2);
    }

    @NotNull
    public static final List<PyDetectedSdk> detectCondaEnvs(@Nullable Module module2, @NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Collection<String> collection = CondaEnvSdkFlavor.INSTANCE.suggestHomePaths(module2);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"CondaEnvSdkFlavor.INSTAN\u2026.suggestHomePaths(module)");
        return PySdkExtKt.filterSuggestedPaths(collection, existingSdks, module2);
    }

    @Nullable
    public static final Sdk createSdkByGenerateTask(@NotNull Task.WithResult<String, ExecutionException> generateSdkHomePath, @NotNull List<? extends Sdk> existingSdks, @Nullable Sdk baseSdk, @Nullable String associatedProjectPath, @Nullable String suggestedSdkName) {
        Collection $receiver$iv;
        String homePath;
        Intrinsics.checkParameterIsNotNull(generateSdkHomePath, (String)"generateSdkHomePath");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        try {
            homePath = (String)ProgressManager.getInstance().run(generateSdkHomePath);
            VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(homePath);
            if (virtualFile == null) {
                throw (Throwable)new ExecutionException("Directory " + homePath + " not found");
            }
            homePath = virtualFile;
        }
        catch (ExecutionException e) {
            PackageManagementService.ErrorDescription errorDescription = PyPackageManagementService.toErrorDescription(CollectionsKt.listOf((Object)((Object)e)), baseSdk);
            if (errorDescription == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)errorDescription, (String)"PyPackageManagementServi\u2026, baseSdk) ?: return null");
            PackageManagementService.ErrorDescription description = errorDescription;
            PackagesNotificationPanel.showError((String)"Failed to Create Interpreter", (PackageManagementService.ErrorDescription)description);
            return null;
        }
        String string = homePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"try {\n    val homePath =\u2026tion)\n    return null\n  }");
        String homeFile = string;
        String string2 = suggestedSdkName;
        if (string2 == null) {
            String string3 = homeFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"homeFile.path");
            string2 = PySdkExtKt.suggestAssociatedSdkName(string3, associatedProjectPath);
        }
        String suggestedName = string2;
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Sdk sdk = SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeFile, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, (String)suggestedName);
        if (sdk == null) {
            return null;
        }
        return sdk;
    }

    public static final void associateWithModule(@NotNull Sdk $receiver, @Nullable Module module2, @Nullable String newProjectPath) {
        PythonSdkAdditionalData pythonSdkAdditionalData;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PythonSdkAdditionalData $receiver2 = pythonSdkAdditionalData = PySdkExtKt.getOrCreateAdditionalData($receiver);
        if (newProjectPath != null) {
            $receiver2.associateWithModulePath(newProjectPath);
        } else if (module2 != null) {
            $receiver2.associateWithModule(module2);
        }
    }

    public static final boolean isAssociatedWithModule(@NotNull Sdk $receiver, @Nullable Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Module module3 = module2;
        String basePath = module3 != null ? PySdkExtKt.getBasePath(module3) : null;
        String associatedPath = PySdkExtKt.getAssociatedModulePath($receiver);
        if (basePath != null && Intrinsics.areEqual((Object)associatedPath, (Object)basePath)) {
            return true;
        }
        if (PySdkExtKt.isAssociatedWithAnotherModule($receiver, module2)) {
            return false;
        }
        return PySdkExtKt.isLocatedInsideModule($receiver, module2) || PySdkExtKt.containsModuleName($receiver, module2);
    }

    public static final boolean isAssociatedWithAnotherModule(@NotNull Sdk $receiver, @Nullable Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = module2;
        if (object == null || (object = PySdkExtKt.getBasePath(object)) == null) {
            return false;
        }
        Object basePath = object;
        String string = PySdkExtKt.getAssociatedModulePath($receiver);
        if (string == null) {
            return false;
        }
        String associatedPath = string;
        return Intrinsics.areEqual((Object)basePath, (Object)associatedPath) ^ true;
    }

    @Nullable
    public static final String getAssociatedModulePath(@NotNull Sdk $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PySdkExtKt.getAssociatedPathFromAdditionalData($receiver);
    }

    @Nullable
    public static final Module getAssociatedModule(@NotNull Sdk $receiver) {
        Object v3;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            String associatedPath = PySdkExtKt.getAssociatedModulePath($receiver);
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Object[] objectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
            Sequence $receiver$iv = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)associatedModule.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                Module it;
                Module module2 = it = (Module)element$iv;
                if (!Intrinsics.areEqual((Object)(module2 != null ? PySdkExtKt.getBasePath(module2) : null), (Object)associatedPath)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    public static final boolean adminPermissionsNeeded(@NotNull Sdk $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHomePath();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return false");
        String homePath = string;
        return !Files.isWritable(Paths.get(homePath, new String[0]));
    }

    @Nullable
    public static final Sdk setup(@NotNull PyDetectedSdk $receiver, @NotNull List<? extends Sdk> existingSdks) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $receiver.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"homeDirectory ?: return null");
        VirtualFile homeDir = virtualFile;
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeDir, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, null);
    }

    @Nullable
    public static final Sdk setupAssociated(@NotNull PyDetectedSdk $receiver, @NotNull List<? extends Sdk> existingSdks, @Nullable String associatedModulePath) {
        Collection $receiver$iv;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        VirtualFile virtualFile = $receiver.getHomeDirectory();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"homeDirectory ?: return null");
        VirtualFile homeDir = virtualFile;
        String string2 = $receiver.getHomePath();
        if (string2 != null) {
            String string3;
            String it;
            String string4 = it = (string3 = string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            string = PySdkExtKt.suggestAssociatedSdkName(string4, associatedModulePath);
        } else {
            string = null;
        }
        String suggestedName = string;
        Collection thisCollection$iv = $receiver$iv = (Collection)existingSdks;
        Sdk[] sdkArray = thisCollection$iv.toArray(new Sdk[0]);
        if (sdkArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SdkConfigurationUtil.setupSdk((Sdk[])sdkArray, (VirtualFile)homeDir, (SdkType)PythonSdkType.getInstance(), (boolean)false, null, (String)suggestedName);
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return PythonSdkType.findPythonSdk($receiver);
    }

    public static final void setPythonSdk(@NotNull Module $receiver, @Nullable Sdk value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ModuleRootModificationUtil.setModuleSdk((Module)$receiver, (Sdk)value);
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull Project $receiver) {
        Sdk sdk;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(this)");
        Sdk sdk2 = sdk = projectRootManager.getProjectSdk();
        SdkTypeId sdkTypeId = sdk2 != null ? sdk2.getSdkType() : null;
        return sdkTypeId instanceof PythonSdkType ? sdk : null;
    }

    public static final void setPythonSdk(@NotNull Project $receiver, @Nullable Sdk value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ApplicationManager.getApplication().runWriteAction(new Runnable($receiver, value){
            final /* synthetic */ Project receiver$0;
            final /* synthetic */ Sdk $value;

            public final void run() {
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.receiver$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(this)");
                projectRootManager.setProjectSdk(this.$value);
            }
            {
                this.receiver$0 = project;
                this.$value = sdk;
            }
        });
    }

    @Nullable
    public static final VirtualFile getBaseDir(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object[] objectArray = ProjectUtil.getRootManager((Module)$receiver).getContentRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootManager.contentRoots");
        return (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
    }

    @Nullable
    public static final String getBasePath(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        VirtualFile virtualFile = PySdkExtKt.getBaseDir($receiver);
        return virtualFile != null ? virtualFile.getPath() : null;
    }

    private static final String suggestAssociatedSdkName(String sdkHome, String associatedPath) {
        String string;
        String baseSdkName;
        block5: {
            block7: {
                String string2;
                block6: {
                    String condaRoot;
                    block4: {
                        String string3 = PythonSdkType.suggestBaseSdkName(sdkHome);
                        if (string3 == null) {
                            return null;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PythonSdkType.suggestBas\u2026e(sdkHome) ?: return null");
                        baseSdkName = string3;
                        File file = PythonSdkType.getVirtualEnvRoot(sdkHome);
                        String venvRoot = file != null ? file.getPath() : null;
                        File file2 = CondaEnvSdkFlavor.getCondaEnvRoot(sdkHome);
                        String string4 = condaRoot = file2 != null ? file2.getPath() : null;
                        if (venvRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)venvRoot, (boolean)true)) break block4;
                        string = PathUtil.getFileName((String)venvRoot);
                        break block5;
                    }
                    if (condaRoot == null || associatedPath != null && FileUtil.isAncestor((String)associatedPath, (String)condaRoot, (boolean)true)) break block6;
                    string = PathUtil.getFileName((String)condaRoot);
                    break block5;
                }
                string = associatedPath;
                if (string == null) break block7;
                String it = string2 = string;
                string = PathUtil.getFileName((String)associatedPath);
                if (string != null) break block5;
            }
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when {\n    venvRoot != n\u2026ath) } ?: return null\n  }");
        String associatedName = string;
        return baseSdkName + " (" + associatedName + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotEmptyDirectory(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!$receiver.exists()) return false;
        if (!$receiver.isDirectory()) return false;
        String[] stringArray = $receiver.list();
        if (stringArray == null) return false;
        String[] stringArray2 = stringArray;
        if (stringArray2.length != 0) return true;
        return false;
    }

    public static final boolean isSystemWide(@NotNull Sdk $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return !PythonSdkType.isRemote($receiver) && !PythonSdkType.isVirtualEnv($receiver) && !PythonSdkType.isCondaVirtualEnv($receiver);
    }

    private static /* synthetic */ void associatedPathFromDotProject$annotations(Sdk sdk) {
    }

    private static final String getAssociatedPathFromDotProject(@NotNull Sdk $receiver) {
        String string;
        String string2 = $receiver.getHomePath();
        if (string2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"homePath ?: return null");
        String binaryPath = string2;
        File file = PythonSdkType.getVirtualEnvRoot(binaryPath);
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"PythonSdkType.getVirtual\u2026inaryPath) ?: return null");
        File virtualEnvRoot = file;
        File projectFile = new File(virtualEnvRoot, ".project");
        try {
            String string3 = string = FilesKt.readText$default((File)projectFile, null, (int)1, null);
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    private static final String getAssociatedPathFromAdditionalData(@NotNull Sdk $receiver) {
        SdkAdditionalData sdkAdditionalData = $receiver.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdkAdditionalData;
        return pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getAssociatedModulePath() : null;
    }

    private static final boolean isLocatedInsideModule(@NotNull Sdk $receiver, Module module2) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return false");
        String homePath = string;
        Object object = module2;
        if (object == null || (object = PySdkExtKt.getBasePath(object)) == null) {
            return false;
        }
        Object basePath = object;
        return FileUtil.isAncestor((String)basePath, (String)homePath, (boolean)true);
    }

    private static final LanguageLevel getGuessedLanguageLevel(@NotNull PyDetectedSdk $receiver) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return null");
        String path = string;
        MatchResult matchResult = Regex.find$default((Regex)new Regex(".*python(\\d\\.\\d)"), (CharSequence)path, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult result = matchResult;
        String string2 = (String)CollectionsKt.getOrNull((List)result.getGroupValues(), (int)1);
        if (string2 == null) {
            return null;
        }
        String versionString = string2;
        return LanguageLevel.fromPythonVersion(versionString);
    }

    private static final boolean containsModuleName(@NotNull Sdk $receiver, Module module2) {
        String string = $receiver.getHomePath();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"homePath ?: return false");
        String path = string;
        Object object = module2;
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"module?.name ?: return false");
        Object name = object;
        return StringsKt.contains((CharSequence)path, (CharSequence)((CharSequence)name), (boolean)true);
    }

    @NotNull
    public static final PythonSdkAdditionalData getOrCreateAdditionalData(@NotNull Sdk $receiver) {
        PythonSdkAdditionalData existingData;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        SdkAdditionalData sdkAdditionalData = $receiver.getSdkAdditionalData();
        if (!(sdkAdditionalData instanceof PythonSdkAdditionalData)) {
            sdkAdditionalData = null;
        }
        if ((existingData = (PythonSdkAdditionalData)sdkAdditionalData) != null) {
            return existingData;
        }
        PythonSdkAdditionalData newData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor($receiver.getHomePath()));
        SdkModificator sdkModificator = $receiver.getSdkModificator();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkModificator, (String)"sdkModificator");
        SdkModificator modificator = sdkModificator;
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(new Runnable(modificator){
            final /* synthetic */ SdkModificator $modificator;

            public final void run() {
                this.$modificator.commitChanges();
            }
            {
                this.$modificator = sdkModificator;
            }
        });
        return newData;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PyDetectedSdk> filterSuggestedPaths(Collection<String> suggestedPaths, List<? extends Sdk> existingSdks, Module module2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)existingSdks;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Sdk sdk = (Sdk)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getHomePath();
            collection.add(string);
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)suggestedPaths), (Function1)((Function1)new Function1<String, Boolean>(existingPaths){
            final /* synthetic */ Set $existingPaths;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$existingPaths.contains(it);
            }
            {
                this.$existingPaths = set;
                super(1);
            }
        }))), (Function1)filterSuggestedPaths.2.INSTANCE);
        Comparator comparator = ComparisonsKt.compareBy((Function1[])new Function1[]{(Function1)new Function1<PyDetectedSdk, Boolean>(module2){
            final /* synthetic */ Module $module;

            public final boolean invoke(@NotNull PyDetectedSdk it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return PySdkExtKt.isAssociatedWithModule((Sdk)it, this.$module);
            }
            {
                this.$module = module2;
                super(1);
            }
        }, filterSuggestedPaths.4.INSTANCE}).reversed();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"compareBy<PyDetectedSdk>\u2026it.homePath }).reversed()");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator));
    }

    @Nullable
    public static final /* synthetic */ LanguageLevel access$getGuessedLanguageLevel$p(@NotNull PyDetectedSdk $receiver) {
        return PySdkExtKt.getGuessedLanguageLevel($receiver);
    }
}

