/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.FluentIterable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.extenstions.PsiElementExtKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiQuery<T extends PsiElement> {
    @NotNull
    private final List<T> myElements;

    public PsiQuery(@NotNull T elementToStart) {
        if (elementToStart == null) {
            PsiQuery.$$$reportNull$$$0(0);
        }
        this(Collections.singletonList(elementToStart));
    }

    public PsiQuery(@NotNull T[] elementsToStart) {
        if (elementsToStart == null) {
            PsiQuery.$$$reportNull$$$0(1);
        }
        this(Arrays.asList(elementsToStart));
    }

    public PsiQuery(@NotNull List<? extends T> elementsToStart) {
        if (elementsToStart == null) {
            PsiQuery.$$$reportNull$$$0(2);
        }
        this.myElements = Collections.unmodifiableList(elementsToStart);
    }

    @NotNull
    public PsiQuery<T> addElements(@NotNull PsiQuery<? extends T> newElements) {
        if (newElements == null) {
            PsiQuery.$$$reportNull$$$0(3);
        }
        ArrayList<T> newList = new ArrayList<T>(this.myElements);
        newList.addAll(newElements.myElements);
        PsiQuery<T> psiQuery = new PsiQuery<T>(newList);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(4);
        }
        return psiQuery;
    }

    @NotNull
    public static <T extends PsiElement> PsiQuery<T> create(@NotNull T elementToStart) {
        if (elementToStart == null) {
            PsiQuery.$$$reportNull$$$0(5);
        }
        PsiQuery<T> psiQuery = new PsiQuery<T>(elementToStart);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(6);
        }
        return psiQuery;
    }

    @NotNull
    public static <T extends PsiElement> PsiQuery<T> createFromQueries(@NotNull List<PsiQuery<? extends T>> queriesWithElements) {
        if (queriesWithElements == null) {
            PsiQuery.$$$reportNull$$$0(7);
        }
        LinkedHashSet result = new LinkedHashSet();
        queriesWithElements.forEach(o -> result.addAll(o.getElements()));
        PsiQuery psiQuery = new PsiQuery(new ArrayList(result));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(8);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends T> PsiQuery<R> filter(@NotNull PsiFilter<R> filter) {
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(9);
        }
        PsiQuery<R> psiQuery = new PsiQuery<R>(filter.filter(this.myElements));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(10);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends T> PsiQuery<R> filter(@NotNull Class<R> filterToType) {
        if (filterToType == null) {
            PsiQuery.$$$reportNull$$$0(11);
        }
        PsiQuery<R> psiQuery = this.filter(new PsiFilter<R>(filterToType));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(12);
        }
        return psiQuery;
    }

    @NotNull
    public PsiQuery<T> filter(@NotNull Predicate<T> filter) {
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(13);
        }
        PsiQuery psiQuery = new PsiQuery(this.asStream().filter(filter).collect(Collectors.toList()));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(14);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> map(@NotNull Function<T, R> map2) {
        if (map2 == null) {
            PsiQuery.$$$reportNull$$$0(15);
        }
        PsiQuery psiQuery = new PsiQuery(this.asStream().map(map2).collect(Collectors.toList()));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(16);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement, F_R extends T> PsiQuery<R> map(@NotNull PsiFilter<F_R> preFilter, @NotNull Function<F_R, R> map2) {
        if (preFilter == null) {
            PsiQuery.$$$reportNull$$$0(17);
        }
        if (map2 == null) {
            PsiQuery.$$$reportNull$$$0(18);
        }
        PsiQuery<R> psiQuery = this.filter(preFilter).map(map2);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(19);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> descendants(@NotNull Class<R> type) {
        if (type == null) {
            PsiQuery.$$$reportNull$$$0(20);
        }
        PsiQuery<R> psiQuery = this.descendants(new PsiFilter<R>(type));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(21);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> ancestors(@NotNull Class<R> type) {
        if (type == null) {
            PsiQuery.$$$reportNull$$$0(22);
        }
        PsiQuery<R> psiQuery = this.ancestors(new PsiFilter<R>(type));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(23);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> siblings(@NotNull Class<R> type) {
        if (type == null) {
            PsiQuery.$$$reportNull$$$0(24);
        }
        PsiQuery<R> psiQuery = this.siblings(new PsiFilter<R>(type));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(25);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> descendants(@NotNull PsiFilter<R> filter) {
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(26);
        }
        PsiQuery<R> psiQuery = this.getQueryWithProducer(o -> PsiTreeUtil.findChildrenOfType((PsiElement)o, (Class)filter.myClass), filter);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(27);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> ancestors(@NotNull PsiFilter<R> filter) {
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(28);
        }
        PsiQuery<R> psiQuery = this.getQueryWithProducer(o -> PsiElementExtKt.getAncestors(o, (PsiElement)o.getContainingFile(), filter.myClass), filter);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(29);
        }
        return psiQuery;
    }

    @NotNull
    public <R extends PsiElement> PsiQuery<R> siblings(@NotNull PsiFilter<R> filter) {
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(30);
        }
        PsiQuery<R> psiQuery = this.getQueryWithProducer(o -> PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)o.getParent(), (Class)filter.myClass), filter);
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(31);
        }
        return psiQuery;
    }

    @NotNull
    private <R extends PsiElement> PsiQuery<R> getQueryWithProducer(@NotNull Function<? super T, ? extends Collection<R>> elementsProducer, @NotNull PsiFilter<R> filter) {
        if (elementsProducer == null) {
            PsiQuery.$$$reportNull$$$0(32);
        }
        if (filter == null) {
            PsiQuery.$$$reportNull$$$0(33);
        }
        LinkedHashSet result = new LinkedHashSet();
        this.asStream().map((? super T o) -> ((Collection)elementsProducer.apply(o)).stream().filter((? super T o2) -> !o2.equals(o)).collect(Collectors.toList())).forEach(result::addAll);
        PsiQuery<R> psiQuery = new PsiQuery<R>(new ArrayList<R>(filter.filter(result)));
        if (psiQuery == null) {
            PsiQuery.$$$reportNull$$$0(34);
        }
        return psiQuery;
    }

    @NotNull
    public Stream<T> asStream() {
        Stream stream = this.myElements.stream();
        if (stream == null) {
            PsiQuery.$$$reportNull$$$0(35);
        }
        return stream;
    }

    @NotNull
    public List<T> getElements() {
        List list = this.asStream().collect(Collectors.toList());
        if (list == null) {
            PsiQuery.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    public T getFirstElement() {
        List<T> elements = this.getElements();
        return (T)(elements.isEmpty() ? null : (PsiElement)elements.get(0));
    }

    @Nullable
    public T getLastElement() {
        List<T> elements = this.getElements();
        return (T)(elements.isEmpty() ? null : (PsiElement)elements.get(elements.size() - 1));
    }

    public boolean exists() {
        return !this.getElements().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToStart";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PsiQuery";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queriesWithElements";
                break;
            }
            case 9: 
            case 13: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterToType";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preFilter";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PsiQuery";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromQueries";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 21: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "descendants";
                break;
            }
            case 23: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestors";
                break;
            }
            case 25: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "siblings";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryWithProducer";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "asStream";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addElements";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFromQueries";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 20: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "descendants";
                break;
            }
            case 22: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ancestors";
                break;
            }
            case 24: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "siblings";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getQueryWithProducer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PsiNameFilter<T extends PsiNamedElement>
    extends PsiFilter<T> {
        @NotNull
        public static PsiNameFilter<PsiNamedElement> create(@NotNull String name) {
            if (name == null) {
                PsiNameFilter.$$$reportNull$$$0(0);
            }
            PsiNameFilter<PsiNamedElement> psiNameFilter = new PsiNameFilter<PsiNamedElement>(PsiNamedElement.class, name);
            if (psiNameFilter == null) {
                PsiNameFilter.$$$reportNull$$$0(1);
            }
            return psiNameFilter;
        }

        public PsiNameFilter(@NotNull Class<? extends T> type, @NotNull String name) {
            if (type == null) {
                PsiNameFilter.$$$reportNull$$$0(2);
            }
            if (name == null) {
                PsiNameFilter.$$$reportNull$$$0(3);
            }
            super(type, (? super T o) -> name.equals(o.getName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PsiQuery$PsiNameFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PsiQuery$PsiNameFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PsiFilter<T extends PsiElement> {
        public static final PsiFilter<PsiElement> ANY = new PsiFilter<PsiElement>(PsiElement.class);
        @NotNull
        private final Class<? extends T> myClass;
        @NotNull
        private final Predicate<? super T> myPredicate;

        public PsiFilter(@NotNull Class<? extends T> aClass, @NotNull Predicate<? super T> predicate) {
            if (aClass == null) {
                PsiFilter.$$$reportNull$$$0(0);
            }
            if (predicate == null) {
                PsiFilter.$$$reportNull$$$0(1);
            }
            this.myClass = aClass;
            this.myPredicate = predicate;
        }

        public PsiFilter(@NotNull Class<? extends T> aClass) {
            if (aClass == null) {
                PsiFilter.$$$reportNull$$$0(2);
            }
            this(aClass, o -> true);
        }

        @NotNull
        List<T> filter(@NotNull Collection<?> list) {
            if (list == null) {
                PsiFilter.$$$reportNull$$$0(3);
            }
            List list2 = FluentIterable.from(list).filter(this.myClass).toList().stream().filter(this.myPredicate).collect(Collectors.toList());
            if (list2 == null) {
                PsiFilter.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PsiQuery$PsiFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PsiQuery$PsiFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

