/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.console;

import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.commandLine.ValidationResult;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.commandInterface.console.CommandConsole;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArgumentHintLayer
extends JPanel
implements PsiModificationTracker.Listener,
Runnable {
    @NotNull
    private static final Pair<String, String> MANDATORY_ARG_BRACES = Pair.create((Object)"<", (Object)">");
    @NotNull
    private static final Pair<String, String> OPTIONAL_ARG_BRACES = Pair.create((Object)"[", (Object)"]");
    @NotNull
    private final LanguageConsoleImpl myConsole;
    @NotNull
    private final Color myRequiredColor;
    @NotNull
    private final Color myOptionalColor;
    @Nullable
    private volatile Pair<Boolean, Argument> myNextArg;
    @NotNull
    private volatile String myLastText;
    private int myCaretPositionPx;

    private ArgumentHintLayer(@NotNull LanguageConsoleImpl console) {
        if (console == null) {
            ArgumentHintLayer.$$$reportNull$$$0(0);
        }
        this.myLastText = "";
        this.myConsole = console;
        this.myLastText = console.getFile().getText();
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myOptionalColor = scheme.getAttributes(ConsoleHighlighter.GRAY).getForegroundColor();
        this.myRequiredColor = scheme.getAttributes(TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES).getForegroundColor();
    }

    public void modificationCountChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String newText = this.myConsole.getFile().getText();
        if (newText.equals(this.myLastText)) {
            return;
        }
        this.myLastText = newText;
        this.myNextArg = null;
        PsiFile consoleFile = this.myConsole.getFile();
        if (consoleFile instanceof CommandLineFile) {
            ValidationResult result = ((CommandLineFile)consoleFile).getValidationResult();
            this.myNextArg = result != null ? result.getNextArg() : null;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Pair<Boolean, Argument> nextArg = this.myNextArg;
        if (nextArg == null) {
            return;
        }
        EditorImpl consoleEditor = PyUtil.as(this.myConsole.getConsoleEditor(), EditorImpl.class);
        if (consoleEditor == null) {
            Logger.getInstance(ArgumentHintLayer.class).warn("Bad editor: " + this.myConsole.getConsoleEditor());
            return;
        }
        int consoleFontType = consoleEditor.getCaretModel().getTextAttributes().getFontType();
        FontMetrics consoleFontMetrics = consoleEditor.getFontMetrics(consoleFontType);
        Font consoleFont = consoleFontMetrics.getFont();
        Graphics2D sourceGraphics2 = PyUtil.as(consoleEditor.getComponent().getGraphics(), Graphics2D.class);
        if (sourceGraphics2 != null && g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHints(sourceGraphics2.getRenderingHints());
        }
        boolean argumentRequired = (Boolean)nextArg.first;
        String argumentText = ((Argument)nextArg.second).getHelp().getHelpString();
        g.setFont(consoleFont);
        g.setColor(argumentRequired ? this.myRequiredColor : this.myOptionalColor);
        String textToShow = ArgumentHintLayer.wrapBracesIfNeeded(argumentRequired, StringUtil.isEmpty((String)argumentText) ? PyBundle.message("commandLine.argumentHint.defaultName", new Object[0]) : argumentText);
        EditorImpl.CaretRectangle[] locations = consoleEditor.getCaretLocations(true);
        if (locations != null) {
            EditorImpl.CaretRectangle rectangle = locations[0];
            this.myCaretPositionPx = rectangle.myPoint.x;
        }
        int consoleEditorTop = consoleEditor.getComponent().getLocation().y;
        double textHeight = Math.floor(consoleFont.getStringBounds(textToShow, consoleFontMetrics.getFontRenderContext()).getY());
        int y = (int)((double)consoleEditorTop - textHeight);
        Point scrollLocation = consoleEditor.getContentComponent().getLocation();
        int spaceWidth = EditorUtil.getSpaceWidth((int)consoleFontType, (Editor)consoleEditor);
        String trimmedDocument = StringUtil.trimTrailing((String)consoleEditor.getDocument().getText());
        double trimmedDocumentWidth = consoleFont.getStringBounds(trimmedDocument, consoleFontMetrics.getFontRenderContext()).getWidth();
        int contentWidth = (int)Math.ceil(trimmedDocumentWidth + (double)consoleEditor.getPrefixTextWidthInPixels());
        g.drawString(textToShow, Math.max(this.myCaretPositionPx, contentWidth) + scrollLocation.x + spaceWidth, y + scrollLocation.y);
    }

    @NotNull
    private static String wrapBracesIfNeeded(boolean required, @NotNull String textToShow) {
        if (textToShow == null) {
            ArgumentHintLayer.$$$reportNull$$$0(1);
        }
        if (textToShow.startsWith((String)ArgumentHintLayer.MANDATORY_ARG_BRACES.first) || textToShow.startsWith((String)ArgumentHintLayer.OPTIONAL_ARG_BRACES.first)) {
            String string = textToShow;
            if (string == null) {
                ArgumentHintLayer.$$$reportNull$$$0(2);
            }
            return string;
        }
        Pair<String, String> braces = required ? MANDATORY_ARG_BRACES : OPTIONAL_ARG_BRACES;
        String string = String.format("%s%s%s", braces.first, textToShow, braces.second);
        if (string == null) {
            ArgumentHintLayer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void run() {
        this.myNextArg = null;
        this.repaint();
    }

    static void attach(@NotNull CommandConsole console) {
        PsiFile consoleFile;
        if (console == null) {
            ArgumentHintLayer.$$$reportNull$$$0(4);
        }
        if (!((consoleFile = console.getFile()) instanceof CommandLineFile)) {
            throw new IllegalArgumentException(String.format("Passed argument is %s, but has to be %s", consoleFile.getClass(), CommandLineFile.class));
        }
        ArgumentHintLayer argumentHintLayer = new ArgumentHintLayer(console);
        console.addStateChangeListener(argumentHintLayer);
        MessageBusConnection connection = console.getProject().getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)argumentHintLayer);
        console.addLayerToPane(argumentHintLayer);
        Disposer.register((Disposable)console, (Disposable)new Disconnector(connection));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToShow";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/console/ArgumentHintLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/console/ArgumentHintLayer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapBracesIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapBracesIfNeeded";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Disconnector
    implements Disposable {
        @NotNull
        private final MessageBusConnection myConnection;

        private Disconnector(@NotNull MessageBusConnection connection) {
            if (connection == null) {
                Disconnector.$$$reportNull$$$0(0);
            }
            this.myConnection = connection;
        }

        public void dispose() {
            this.myConnection.disconnect();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/commandInterface/console/ArgumentHintLayer$Disconnector", "<init>"));
        }
    }
}

