/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ui.SelectCvsConfigurationPanel;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MigrateRootDialog
extends DialogWrapper {
    private final JRadioButton myRadioButton1;
    private final JRadioButton myRadioButton2 = new JRadioButton(CvsBundle.message((String)"migrate.replace.all.roots.label", (Object[])new Object[0]));
    private final TextFieldWithBrowseButton myDirectoryField = new TextFieldWithBrowseButton();
    private final SelectCvsConfigurationPanel myCvsConfigurationPanel;
    private final ListSelectionListener myListener;
    private String myCvsRoot;

    public MigrateRootDialog(Project project, VirtualFile directory) {
        super(project);
        this.setTitle("Migrate CVS Root");
        File file = CvsVfsUtil.getFileFor(directory);
        String root = CvsUtil.loadRootFrom(file);
        this.myRadioButton1 = new JRadioButton(CvsBundle.message((String)"migrate.replace.if.root.equals.label", (Object[])new Object[]{root}));
        this.myRadioButton1.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRadioButton1);
        group.add(this.myRadioButton2);
        this.myDirectoryField.setText(directory.getPath());
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                for (VirtualFile vFile : files) {
                    File file = CvsVfsUtil.getFileFor(vFile);
                    String root = CvsUtil.loadRootFrom(file);
                    if (root != null) continue;
                    throw new Exception(CvsBundle.message((String)"error.message.directory.is.not.under.cvs", (Object[])new Object[0]));
                }
            }
        };
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules());
        this.myDirectoryField.addBrowseFolderListener("Select directory to migrate to a new CVS root", "", project, descriptor);
        FileChooserFactory.getInstance().installFileCompletion((JTextField)this.myDirectoryField.getChildComponent(), descriptor, true, this.getDisposable());
        this.myDirectoryField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MigrateRootDialog.this.enableOKActionConditionally();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MigrateRootDialog.this.enableOKActionConditionally();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MigrateRootDialog.this.enableOKActionConditionally();
            }
        });
        this.myCvsConfigurationPanel = new SelectCvsConfigurationPanel(project);
        if (SystemInfo.isMac) {
            this.myCvsConfigurationPanel.setBorder(new EmptyBorder(2, 3, 2, 0));
        }
        this.myListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MigrateRootDialog.this.enableOKActionConditionally();
            }
        };
        this.myCvsConfigurationPanel.addListSelectionListener(this.myListener);
        this.setOKButtonText("Migrate");
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        JLabel label1 = new JLabel(CvsBundle.message((String)"migrate.cvs.root.directory.label", (Object[])new Object[0]));
        label1.setLabelFor((Component)this.myDirectoryField);
        panel.add((Component)label1, constraints);
        constraints.gridy = 1;
        panel.add((Component)this.myDirectoryField, constraints);
        constraints.gridy = 2;
        constraints.insets.left = 5;
        panel.add((Component)this.myRadioButton1, constraints);
        constraints.gridy = 3;
        panel.add((Component)this.myRadioButton2, constraints);
        constraints.gridy = 4;
        constraints.insets.top = 8;
        constraints.insets.left = 0;
        JLabel label2 = new JLabel(CvsBundle.message((String)"migrate.target.root.label", (Object[])new Object[0]));
        panel.add((Component)label2, constraints);
        JComponent component = this.myCvsConfigurationPanel.getPreferredFocusedComponent();
        label2.setLabelFor(component);
        constraints.insets.top = 0;
        constraints.gridy = 5;
        panel.add((Component)this.myCvsConfigurationPanel, constraints);
        return panel;
    }

    private boolean check() {
        String text = this.myDirectoryField.getText();
        File file = new File(text);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        this.myCvsRoot = CvsUtil.loadRootFrom(file);
        if (this.myCvsRoot == null) {
            return false;
        }
        this.myRadioButton1.setText(CvsBundle.message((String)"migrate.replace.if.root.equals.label", (Object[])new Object[]{this.myCvsRoot}));
        return this.getSelectedCvsConfiguration() != null;
    }

    protected void dispose() {
        this.myCvsConfigurationPanel.removeListSelectionListener(this.myListener);
        super.dispose();
    }

    private void enableOKActionConditionally() {
        this.setOKActionEnabled(this.check());
    }

    public String getCvsRoot() {
        return this.myCvsRoot;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCvsConfigurationPanel;
    }

    public CvsRootConfiguration getSelectedCvsConfiguration() {
        return this.myCvsConfigurationPanel.getSelectedConfiguration();
    }

    public File getSelectedDirectory() {
        return new File(this.myDirectoryField.getText());
    }

    public boolean shouldReplaceAllRoots() {
        return this.myRadioButton2.isSelected();
    }
}

