/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;

public abstract class AnyProcessedFiles
extends FileSetToBeUpdated {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvshandlers.AnyProcessedFiles");

    public abstract Collection<VirtualFile> getFiles();

    @Override
    public void refreshFilesAsync(final Runnable postRunnable) {
        final VirtualFile[] files = VfsUtil.toVirtualFileArray(this.getFiles());
        final int[] index = new int[]{0};
        LOG.info("files.length=" + files.length);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (index[0] < files.length) {
                    int n = index[0];
                    index[0] = n + 1;
                    VirtualFile file = files[n];
                    if (file.isValid()) {
                        LOG.info("Refreshing:" + file);
                        file.refresh(true, true, (Runnable)this);
                    } else {
                        LOG.info("Skipping file");
                        this.run();
                    }
                } else {
                    LOG.info("postRunnable!");
                    if (postRunnable != null) {
                        postRunnable.run();
                    }
                }
            }
        };
        runnable.run();
    }

    @Override
    public void refreshFilesSync() {
        for (VirtualFile file : this.getFiles()) {
            file.refresh(false, true);
        }
    }
}

