/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.util.Util;
import org.apache.felix.main.AutoProcessor;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static final String BUNDLE_DIR_SWITCH = "-b";
    public static final String SHUTDOWN_HOOK_PROP = "felix.shutdown.hook";
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    private static Framework m_fwk = null;

    public static void main(String[] args) throws Exception {
        String enableHook;
        String bundleDir = null;
        String cacheDir = null;
        boolean expectBundleDir = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(BUNDLE_DIR_SWITCH)) {
                expectBundleDir = true;
                continue;
            }
            if (expectBundleDir) {
                bundleDir = args[i];
                expectBundleDir = false;
                continue;
            }
            cacheDir = args[i];
        }
        if (args.length > 3 || expectBundleDir && bundleDir == null) {
            System.out.println("Usage: [-b <bundle-deploy-dir>] [<bundle-cache-dir>]");
            System.exit(0);
        }
        Main.loadSystemProperties();
        Map<String, String> configProps = Main.loadConfigProperties();
        if (configProps == null) {
            System.err.println("No config.properties found.");
            configProps = new HashMap<String, String>();
        }
        Main.copySystemProperties(configProps);
        if (bundleDir != null) {
            configProps.put("felix.auto.deploy.dir", bundleDir);
        }
        if (cacheDir != null) {
            configProps.put("org.osgi.framework.storage", cacheDir);
        }
        if ((enableHook = configProps.get(SHUTDOWN_HOOK_PROP)) == null || !enableHook.equalsIgnoreCase("false")) {
            Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

                public void run() {
                    try {
                        if (m_fwk != null) {
                            m_fwk.stop();
                            m_fwk.waitForStop(0L);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Error stopping framework: " + ex);
                    }
                }
            });
        }
        try {
            FrameworkEvent event;
            FrameworkFactory factory = Main.getFrameworkFactory();
            m_fwk = factory.newFramework(configProps);
            m_fwk.init();
            AutoProcessor.process(configProps, m_fwk.getBundleContext());
            do {
                m_fwk.start();
            } while ((event = m_fwk.waitForStop(0L)).getType() == 128);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrameworkFactory getFrameworkFactory() throws Exception {
        URL url = Main.class.getClassLoader().getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new Exception("Could not find framework factory.");
    }

    public static void loadSystemProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(SYSTEM_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, SYSTEM_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Util.substVars(props.getProperty(name), name, null, null));
        }
    }

    public static Map<String, String> loadConfigProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(CONFIG_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return null;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, CONFIG_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (Exception ex) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            map.put(name, Util.substVars(props.getProperty(name), name, null, props));
        }
        return map;
    }

    public static void copySystemProperties(Map configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.put(key, System.getProperty(key));
        }
    }
}

