/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/stm32/g0/irq.json
 */

#ifndef LIBOPENCM3_STM32_G0_NVIC_H
#define LIBOPENCM3_STM32_G0_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for STM32 G0 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_WWDG_IRQ 0
#define NVIC_PVD_IRQ 1
#define NVIC_RTC_IRQ 2
#define NVIC_FLASH_IRQ 3
#define NVIC_RCC_IRQ 4
#define NVIC_EXTI0_1_IRQ 5
#define NVIC_EXTI2_3_IRQ 6
#define NVIC_EXTI4_15_IRQ 7
#define NVIC_UCPD1_UCPD2_IRQ 8
#define NVIC_DMA1_CHANNEL1_IRQ 9
#define NVIC_DMA1_CHANNEL2_3_IRQ 10
#define NVIC_DMA1_CHANNEL4_7_DMAMUX_IRQ 11
#define NVIC_ADC_COMP_IRQ 12
#define NVIC_TIM1_BRK_UP_TRG_COM_IRQ 13
#define NVIC_TIM1_CC_IRQ 14
#define NVIC_TIM2_IRQ 15
#define NVIC_TIM34_IRQ 16
#define NVIC_TIM6_DAC_LPTIM1_IRQ 17
#define NVIC_TIM7_LPTIM2_IRQ 18
#define NVIC_TIM14_IRQ 19
#define NVIC_TIM15_IRQ 20
#define NVIC_TIM16_FDCAN_IT0_IRQ 21
#define NVIC_TIM17_FDCAN_IT1_IRQ 22
#define NVIC_I2C1_IRQ 23
#define NVIC_I2C23_IRQ 24
#define NVIC_SPI1_IRQ 25
#define NVIC_SPI23_IRQ 26
#define NVIC_USART1_IRQ 27
#define NVIC_USART2_LPUART2_IRQ 28
#define NVIC_USART3456_LPUART1_IRQ 29
#define NVIC_CEC_IRQ 30
#define NVIC_AES_RNG_IRQ 31

#define NVIC_IRQ_COUNT 32

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_STM32G0 User interrupt service routines (ISR) prototypes for STM32 G0 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void wwdg_isr(void);
void pvd_isr(void);
void rtc_isr(void);
void flash_isr(void);
void rcc_isr(void);
void exti0_1_isr(void);
void exti2_3_isr(void);
void exti4_15_isr(void);
void ucpd1_ucpd2_isr(void);
void dma1_channel1_isr(void);
void dma1_channel2_3_isr(void);
void dma1_channel4_7_dmamux_isr(void);
void adc_comp_isr(void);
void tim1_brk_up_trg_com_isr(void);
void tim1_cc_isr(void);
void tim2_isr(void);
void tim34_isr(void);
void tim6_dac_lptim1_isr(void);
void tim7_lptim2_isr(void);
void tim14_isr(void);
void tim15_isr(void);
void tim16_fdcan_it0_isr(void);
void tim17_fdcan_it1_isr(void);
void i2c1_isr(void);
void i2c23_isr(void);
void spi1_isr(void);
void spi23_isr(void);
void usart1_isr(void);
void usart2_lpuart2_isr(void);
void usart3456_lpuart1_isr(void);
void cec_isr(void);
void aes_rng_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_STM32_G0_NVIC_H */
