/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.ToStringUtil;
import org.apache.lucene.analysis.gosen.tokenAttributes.ReadingsAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class GosenReadingsFormFilter
extends TokenFilter {
    private boolean romanized;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ReadingsAttribute readingsAtt = (ReadingsAttribute)this.addAttribute(ReadingsAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public GosenReadingsFormFilter(TokenStream input) {
        this(input, false);
    }

    public GosenReadingsFormFilter(TokenStream input, boolean romanized) {
        super(input);
        this.romanized = romanized;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            List<String> readings;
            if (!this.keywordAtt.isKeyword() && (readings = this.readingsAtt.getReadings()) != null) {
                StringBuilder sb = new StringBuilder();
                for (String reading : readings) {
                    sb.append(this.romanized ? ToStringUtil.getRomanization(reading) : reading);
                }
                this.termAtt.setEmpty().append(sb.toString());
            }
            return true;
        }
        return false;
    }
}

