/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;

public abstract class AbstractUserAdapter
implements UserModel {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;
    protected long created = System.currentTimeMillis();

    public AbstractUserAdapter(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    @Override
    public Set<String> getRequiredActions() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void addRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.EMPTY_SET;
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    @Override
    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroups());
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    @Override
    public void joinGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void leaveGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isMemberOf(GroupModel group) {
        Set<GroupModel> roles = this.getGroups();
        return RoleUtils.isMember(roles, group);
    }

    @Override
    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    @Override
    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return RoleUtils.hasRole(roles, role) || RoleUtils.hasRoleFromGroup(this.getGroups(), role, true);
    }

    @Override
    public void grantRole(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(DefaultRoles.getDefaultRoles(this.realm));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getFederationLink() {
        return null;
    }

    @Override
    public void setFederationLink(String link) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getServiceAccountClientLink() {
        return null;
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    @Override
    public void setUsername(String username) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public Long getCreatedTimestamp() {
        return this.created;
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeAttribute(String name) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getFirstAttribute(String name) {
        return null;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return new MultivaluedHashMap();
    }

    @Override
    public List<String> getAttribute(String name) {
        return null;
    }

    @Override
    public String getFirstName() {
        return null;
    }

    @Override
    public void setFirstName(String firstName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getLastName() {
        return null;
    }

    @Override
    public void setLastName(String lastName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public void setEmail(String email) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isEmailVerified() {
        return false;
    }

    @Override
    public void setEmailVerified(boolean verified) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

