/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.SecuritySupport;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.spi.Converter;

public final class Converters {
    static final Converter<String> STRING_CONVERTER = BuiltInConverter.of(0, (Converter & Serializable)value -> value);
    static final Converter<Boolean> BOOLEAN_CONVERTER = BuiltInConverter.of(1, (Converter & Serializable)value -> {
        if (value != null) {
            return "TRUE".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value) || "Y".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "JA".equalsIgnoreCase(value) || "J".equalsIgnoreCase(value) || "SI".equalsIgnoreCase(value) || "SIM".equalsIgnoreCase(value) || "OUI".equalsIgnoreCase(value);
        }
        return null;
    });
    static final Converter<Double> DOUBLE_CONVERTER = BuiltInConverter.of(2, (Converter & Serializable)value -> value != null ? Double.valueOf(value) : null);
    static final Converter<Float> FLOAT_CONVERTER = BuiltInConverter.of(3, (Converter & Serializable)value -> value != null ? Float.valueOf(value) : null);
    static final Converter<Long> LONG_CONVERTER = BuiltInConverter.of(4, (Converter & Serializable)value -> value != null ? Long.valueOf(value) : null);
    static final Converter<Integer> INTEGER_CONVERTER = BuiltInConverter.of(5, (Converter & Serializable)value -> value != null ? Integer.valueOf(value) : null);
    static final Converter<Class<?>> CLASS_CONVERTER = BuiltInConverter.of(6, (Converter & Serializable)value -> {
        try {
            return value != null ? Class.forName(value, true, SecuritySupport.getContextClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    });
    static final Converter<OptionalInt> OPTIONAL_INT_CONVERTER = BuiltInConverter.of(7, (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalInt.of(Integer.parseInt(value)) : OptionalInt.empty());
    static final Converter<OptionalLong> OPTIONAL_LONG_CONVERTER = BuiltInConverter.of(8, (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalLong.of(Long.parseLong(value)) : OptionalLong.empty());
    static final Converter<OptionalDouble> OPTIONAL_DOUBLE_CONVERTER = BuiltInConverter.of(9, (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalDouble.of(Double.parseDouble(value)) : OptionalDouble.empty());
    static final Converter<InetAddress> INET_ADDRESS_CONVERTER = BuiltInConverter.of(10, (Converter & Serializable)value -> {
        try {
            return value != null && !value.isEmpty() ? InetAddress.getByName(value) : null;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    });
    static final Map<Type, Converter<?>> ALL_CONVERTERS = new HashMap();

    private Converters() {
    }

    public static Type getConverterType(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be parameterized with a single type");
            }
            return typeArguments[0];
        }
        return Converters.getConverterType(clazz.getSuperclass());
    }

    static {
        ALL_CONVERTERS.put((Type)((Object)String.class), STRING_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Boolean.class), BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put(Boolean.TYPE, BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Double.class), DOUBLE_CONVERTER);
        ALL_CONVERTERS.put(Double.TYPE, DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Float.class), FLOAT_CONVERTER);
        ALL_CONVERTERS.put(Float.TYPE, FLOAT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Long.class), LONG_CONVERTER);
        ALL_CONVERTERS.put(Long.TYPE, LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Integer.class), INTEGER_CONVERTER);
        ALL_CONVERTERS.put(Integer.TYPE, INTEGER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Class.class), CLASS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)InetAddress.class), INET_ADDRESS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalInt.class), OPTIONAL_INT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalLong.class), OPTIONAL_LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalDouble.class), OPTIONAL_DOUBLE_CONVERTER);
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 5646753664957303950L;
        private final short id;

        Ser(int id) {
            this.id = (short)id;
        }

        Object readResolve() throws ObjectStreamException {
            switch (this.id) {
                case 0: {
                    return STRING_CONVERTER;
                }
                case 1: {
                    return BOOLEAN_CONVERTER;
                }
                case 2: {
                    return DOUBLE_CONVERTER;
                }
                case 3: {
                    return FLOAT_CONVERTER;
                }
                case 4: {
                    return LONG_CONVERTER;
                }
                case 5: {
                    return INTEGER_CONVERTER;
                }
                case 6: {
                    return CLASS_CONVERTER;
                }
                case 7: {
                    return INET_ADDRESS_CONVERTER;
                }
                case 8: {
                    return OPTIONAL_INT_CONVERTER;
                }
                case 9: {
                    return OPTIONAL_LONG_CONVERTER;
                }
                case 10: {
                    return OPTIONAL_DOUBLE_CONVERTER;
                }
            }
            throw new InvalidObjectException("Unknown converter ID");
        }
    }

    static final class BuiltInConverter<T>
    implements Converter<T>,
    Serializable {
        private final int id;
        private final Converter<T> function;

        static <T> BuiltInConverter<T> of(int id, Converter<T> function) {
            return new BuiltInConverter<T>(id, function);
        }

        private BuiltInConverter(int id, Converter<T> function) {
            this.id = id;
            this.function = function;
        }

        public T convert(String value) {
            return (T)this.function.convert(value);
        }

        Object writeReplace() {
            return new Ser(this.id);
        }
    }
}

