/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.aesh;

import java.lang.reflect.Method;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.console.AeshConsoleCallback;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerResult;
import org.jboss.aesh.console.command.invocation.AeshCommandInvocation;
import org.jboss.aesh.console.command.invocation.AeshCommandInvocationProvider;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.ParserStatus;
import org.keycloak.client.admin.cli.aesh.Globals;

class AeshConsoleCallbackImpl
extends AeshConsoleCallback {
    private final AeshConsoleImpl console;
    private CommandResult result;

    AeshConsoleCallbackImpl(AeshConsoleImpl aeshConsole) {
        this.console = aeshConsole;
    }

    @Override
    public int execute(ConsoleOperation output) throws InterruptedException {
        if (output != null && output.getBuffer().trim().length() > 0) {
            ResultHandler resultHandler = null;
            AeshLine aeshLine = new AeshLine(output.getBuffer(), Globals.args, ParserStatus.OK, "");
            try (CommandContainer commandContainer = this.getCommand(output, aeshLine);){
                resultHandler = commandContainer.getParser().getProcessedCommand().getResultHandler();
                CommandContainerResult ccResult = commandContainer.executeCommand(aeshLine, this.console.getInvocationProviders(), this.console.getAeshContext(), new AeshCommandInvocationProvider().enhanceCommandInvocation(new AeshCommandInvocation(this.console, output.getControlOperator(), output.getPid(), this)));
                this.result = ccResult.getCommandResult();
                if (this.result == CommandResult.SUCCESS && resultHandler != null) {
                    resultHandler.onSuccess();
                } else if (resultHandler != null) {
                    resultHandler.onFailure(this.result);
                }
                if (this.result == CommandResult.FAILURE) {
                    System.exit(1);
                }
            }
            catch (Exception e) {
                this.console.stop();
                if (e instanceof OptionParserException) {
                    System.err.println("Unknown command: " + aeshLine.getWords().get(0));
                } else {
                    System.err.println(e.getMessage());
                }
                if (Globals.dumpTrace) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        } else {
            this.result = output != null ? CommandResult.FAILURE : CommandResult.FAILURE;
        }
        if (this.result == CommandResult.SUCCESS) {
            return 0;
        }
        return 1;
    }

    private CommandContainer getCommand(ConsoleOperation output, AeshLine aeshLine) throws CommandNotFoundException {
        Method m;
        try {
            m = this.console.getClass().getDeclaredMethod("getCommand", AeshLine.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
        m.setAccessible(true);
        try {
            return (CommandContainer)m.invoke((Object)this.console, aeshLine, output.getBuffer());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error: ", e);
        }
    }
}

