#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.21
visibility:           public
id:                   hledger-web-1.21-G7GwT333zRZCGefw5LfSl2
key:                  hledger-web-1.21-G7GwT333zRZCGefw5LfSl2
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web-based user interface for the hledger accounting system
description:
    A simple web-based user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  a094888822c5b9aa0ee6ce19fe5c4bf8
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-8.10.5/site-local/hledger-web-1.21
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hledger-web-1.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.21-G7GwT333zRZCGefw5LfSl2
depends:
    Decimal-0.5.2-AYuaR1EHZlVAymHng0hOIa
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    blaze-html-0.9.1.2-3gWJOEFN3Rn7Mv2jAJdKwl
    blaze-markup-0.8.2.8-8RebaU3zReM4AoTFuL4PYs bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB
    clientsession-0.9.1.2-Cx2mUejZNOI3hjS5yIhZLB
    cmdargs-0.10.21-Gp5sk8nLdQ1LCjZIDntuGG
    conduit-1.3.4.1-GHgRKpknFuqDscwzVojbiE
    conduit-extra-1.3.5-6wbdzvOjyuAGkpGhMnpbur containers-0.6.4.1
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX directory-1.3.6.0
    extra-1.7.9-4atxCqewDRnKsFBrL9ak4x filepath-1.4.2.1
    hjsmin-0.2.0.4-4xf0wz1tXRf8O65TGX9JEu
    hledger-1.21-1PoycfTWj6sI8Mq00QI5P7
    hledger-lib-1.21-GW8w2wItIQTDmdL3DkeG40
    hspec-2.8.2-HsNEIXhYrouFTll0mN5G5C
    http-client-0.7.8-C6JWYZrbeBCPAdb6EpQD6
    http-conduit-2.3.8-EHVj4SxGcYE5sNggtZCndH
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    megaparsec-9.0.1-CgNxKp13Re58VqY3iga6b3 mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    shakespeare-2.0.25-9PoqIRIh6zmA0h3TqA8xt9 template-haskell-2.16.0.0
    text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    wai-3.2.3-6NrdunSiuKK6vnccK2cwty
    wai-cors-0.2.7-DepLhfPh3hjCzFTL7eCI8S
    wai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
    wai-handler-launch-3.0.3.1-HK4MsEpml2OB90w0jk4spp
    warp-3.3.16-JCGQXtllRgYC0aGKpmQh8V
    yaml-0.11.5.0-7UJv2Fq2f113FoCoCodYb3
    yesod-1.6.1.1-DAHt1E0kwYMJ6GeypJJo1C
    yesod-core-1.6.20.1-AZEcK2kpTthHerC9UzYV34
    yesod-form-1.7.0-MK5exFvdoI2UH5GBUZOiL
    yesod-static-1.6.1.0-9FsxVdVTNJFCR1aJ60BH4f
    yesod-test-1.6.12-1A8tJnWeUeOEk8nJHxiFmK

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

