#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-iadd
version:              1.3.14
visibility:           public
id:                   hledger-iadd-1.3.14-5GQPrL3IBI07VBKvmfrYzp
key:                  hledger-iadd-1.3.14-5GQPrL3IBI07VBKvmfrYzp
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  d2f5e07eac7670a02c9dc5fe23978592
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hledger-iadd-1.3.14
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hledger-iadd-1.3.14
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hledger-iadd-1.3.14
hs-libraries:         HShledger-iadd-1.3.14-5GQPrL3IBI07VBKvmfrYzp
depends:
    base-4.14.2.0 brick-0.62-GEDIdRojm708B9XWArXyY8 containers-0.6.4.1
    directory-1.3.6.0 free-5.1.7-2idoL1WYcJhANXuZGXa5gQ
    hledger-lib-1.21-4LkWXXbomYt3UBZfAN7Ag9
    megaparsec-9.0.1-EfqOpHe5vHjEbErI3bJkbj
    microlens-0.4.12.0-7mbtYeVEJj9DE2AV66WaoK
    microlens-th-0.4.3.10-L22hJd4Bpy6EfILCAvCrvo
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e text-1.2.4.1
    text-zipper-0.11-JuStmvOo8JxCk7feJOi07i time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-8aHRrFmFeW5FoD6sXDqCak
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    vty-5.33-4Fva1bkydz4IOPLJ5WtUfa
    xdg-basedir-0.2.2-HxO6vm11dHzJE1a7l4Y8Vh

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

