#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.21
visibility:           public
id:                   hledger-1.21-1PoycfTWj6sI8Mq00QI5P7
key:                  hledger-1.21-1PoycfTWj6sI8Mq00QI5P7
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  97e674df62b30e3f8685915293422de7
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Check.Ordereddates
    Hledger.Cli.Commands.Check.Uniqueleafnames
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Descriptions
    Hledger.Cli.Commands.Diff Hledger.Cli.Commands.Files
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Notes
    Hledger.Cli.Commands.Payees Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Printunique
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Registermatch
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Roi
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.DocFiles
    Hledger.Cli.Main Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-8.10.5/site-local/hledger-1.21
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hledger-1.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.21-1PoycfTWj6sI8Mq00QI5P7
depends:
    Decimal-0.5.2-AYuaR1EHZlVAymHng0hOIa
    Diff-0.4.0-13VXofqCMLyHuBACVASIzF
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i base-4.14.2.0
    base-compat-batteries-0.11.2-Adi2U3TFDt9D7s2pHONdZC
    bytestring-0.10.12.0 cmdargs-0.10.21-Gp5sk8nLdQ1LCjZIDntuGG
    containers-0.6.4.1 data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX
    directory-1.3.6.0 extra-1.7.9-4atxCqewDRnKsFBrL9ak4x
    filepath-1.4.2.1 hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    haskeline-0.8.0.1 hledger-lib-1.21-GW8w2wItIQTDmdL3DkeG40
    lucid-2.9.12.1-9oIuMQbP4r48YxtDtY8LUx
    math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
    megaparsec-9.0.1-CgNxKp13Re58VqY3iga6b3 mtl-2.2.2
    old-time-1.1.0.3-L4487sR2g8B3hwiiVWHb93 process-1.6.9.0
    regex-tdfa-1.3.1.1-GKHvEQcFLVkJ8X6kzhWyIo
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    shakespeare-2.0.25-9PoqIRIh6zmA0h3TqA8xt9
    split-0.2.3.4-Fv3j3BhtJgT8PrdAoYtOLl
    tabular-0.2.2.8-Hcf2VtEmwf82qKCXc6kljp
    tasty-1.4.1-o6GqK7uhQW6VZVrPJnWQG
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU terminfo-0.4.1.4 text-1.2.4.1
    time-1.9.3 timeit-2.0-9v31DY9p9ojLe6jxDFX4lL transformers-0.5.6.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    utility-ht-0.0.16-24GowJ9ezK6J2J6n2aO3mj
    wizards-1.0.3-D6F1Ie8nXml21cuChbk09x

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

