#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 websockets
version:              0.12.7.2
visibility:           public
id:                   websockets-0.12.7.2-85saducd4mh7JOMIBzytg3
key:                  websockets-0.12.7.2-85saducd4mh7JOMIBzytg3
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  e0f1a12fa406cf6378013fca58c82f60
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-8.10.5/site-local/websockets-0.12.7.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/websockets-0.12.7.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/websockets-0.12.7.2
hs-libraries:         HSwebsockets-0.12.7.2-85saducd4mh7JOMIBzytg3
depends:
    SHA-1.6.4.4-AdaX3b9QKHpD4bkKnWphTy
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R binary-0.8.8.0
    bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB
    clock-0.8.2-CUh6FGzlB8CArRlXh1LKmY containers-0.6.4.1
    entropy-0.4.1.6-mwZ4jE2F7MEzr0ctFVs6J
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu
    streaming-commons-0.2.2.1-C8lvasNXOGTK9YCgFpiJpk text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

