#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.6
visibility:           public
id:                   wai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
key:                  wai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  b84a36f8cac00c689d50591b0e295c20
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.Jsonp Network.Wai.Middleware.Local
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:       Network.Wai.Middleware.RequestLogger.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/wai-extra-3.1.6
library-dirs:         /usr/lib/ghc-8.10.5/site-local/wai-extra-3.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/wai-extra-3.1.6
hs-libraries:         HSwai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
depends:
    HUnit-1.6.2.0-8FsjWfKzSV74wDnwnuEJe4
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i base-4.14.2.0
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R
    bytestring-0.10.12.0 call-stack-0.3.0-HaJG5jRa2XM74od97nDj56
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB containers-0.6.4.1
    cookie-0.4.5-DRjKUovO6l159RRdguKqPl
    data-default-class-0.1.2.0-9cFfQKP7sucLLfD3ZZyiPI directory-1.3.6.0
    fast-logger-3.0.5-I5dfCGxOK271HLzqt5yeow
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    http2-3.0.2-4MFc8lpSzy29t1ReDOKVbF
    iproute-1.7.11-d5s0fig5u67LjOGRvUkdk
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    resourcet-1.2.4.2-7etOfd8fePh2l91avxjTIe
    streaming-commons-0.2.2.1-C8lvasNXOGTK9YCgFpiJpk text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-2u0dJePH52AL9bdJMWCcCZ
    wai-3.2.3-6NrdunSiuKK6vnccK2cwty
    wai-logger-2.3.6-D38BZlKnHPTKsiCW915NQw
    word8-0.1.3-C9wcaZKtRvf9CTebSJFNpx

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

