#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid
version:              1.3.15
visibility:           public
id:                   uuid-1.3.15-AKTgcL3LOBPLKcWo3t3zYb
key:                  uuid-1.3.15-AKTgcL3LOBPLKcWo3t3zYb
license:              BSD-3-Clause
copyright:            (c) 2008-2014 Antoine Latter
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:
    For creating, comparing, parsing and printing Universally Unique Identifiers

description:
    This library is useful for creating, comparing, parsing and
    printing Universally Unique Identifiers.

    See <http://en.wikipedia.org/wiki/UUID> for the general idea.

category:             Data
abi:                  1741fb604753313d729279ac340ee36b
exposed:              True
exposed-modules:
    Data.UUID Data.UUID.Util Data.UUID.V1 Data.UUID.V3 Data.UUID.V4
    Data.UUID.V5

hidden-modules:       Data.UUID.Named Data.Word.Util
import-dirs:          /usr/lib/ghc-8.10.5/site-local/uuid-1.3.15
library-dirs:         /usr/lib/ghc-8.10.5/site-local/uuid-1.3.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/uuid-1.3.15
hs-libraries:         HSuuid-1.3.15-AKTgcL3LOBPLKcWo3t3zYb
depends:
    base-4.14.2.0 binary-0.8.8.0 bytestring-0.10.12.0
    cryptohash-md5-0.11.100.1-CXcVdCBElEw85IPjFl0LYl
    cryptohash-sha1-0.11.100.1-HA3MUFqd1UUI8eb8HGKp7P
    entropy-0.4.1.6-mwZ4jE2F7MEzr0ctFVs6J
    network-info-0.2.0.10-9tBDnpf4RI1CDFbuwuYidN
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu text-1.2.4.1 time-1.9.3
    uuid-types-1.0.5-BD8YLQbwrdV1wSNOkK6P8E

haddock-interfaces:   /usr/share/doc/haskell-uuid/html/uuid.haddock
haddock-html:         /usr/share/doc/haskell-uuid/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

