#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 turtle
version:              1.5.22
visibility:           public
id:                   turtle-1.5.22-9zTgWa7VaRG60zcwerCr3V
key:                  turtle-1.5.22-9zTgWa7VaRG60zcwerCr3V
license:              BSD-3-Clause
copyright:            2015 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@ and @system-filepath@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  79580945d4f3856ac73cbf11f0a59b80
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/turtle-1.5.22
library-dirs:         /usr/lib/ghc-8.10.5/site-local/turtle-1.5.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/turtle-1.5.22
hs-libraries:         HSturtle-1.5.22-9zTgWa7VaRG60zcwerCr3V
depends:
    ansi-wl-pprint-0.6.9-18xfpSFHwXcSLsLHaSUhO
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    bytestring-0.10.12.0 clock-0.8.2-CUh6FGzlB8CArRlXh1LKmY
    containers-0.6.4.1 directory-1.3.6.0 exceptions-0.10.4
    foldl-1.4.11-3n1BKNutTNL5yIx0tnC0E
    hostname-1.0-B6rimLIP2kIHedZYMVt5f8
    managed-1.0.8-7dDi1QnJFf08rXWKXOzZaH
    optional-args-1.0.2-9OyrdlAC6cZ8cGfANqqKxz
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    process-1.6.9.0 stm-2.5.0.1
    streaming-commons-0.2.2.1-C8lvasNXOGTK9YCgFpiJpk
    system-fileio-0.3.16.4-HLa3qh7Xir27kpEIMqLlx
    system-filepath-0.4.14-EteQbvW1sOP6ea4Eitj1Mn
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

