#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 th-desugar
version:              1.12
visibility:           public
id:                   th-desugar-1.12-8qbkewjc8FP5ZJRMpkEsgj
key:                  th-desugar-1.12-8qbkewjc8FP5ZJRMpkEsgj
license:              BSD-3-Clause
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Richard Eisenberg <rae@cs.brynmawr.edu>
stability:            experimental
homepage:             https://github.com/goldfirere/th-desugar
synopsis:             Functions to desugar Template Haskell
description:
    This package provides the Language.Haskell.TH.Desugar module, which desugars
    Template Haskell'\''s rich encoding of Haskell syntax into a simpler encoding.
    This desugaring discards surface syntax information (such as the use of infix
    operators) but retains the original meaning of the TH code. The intended use
    of this package is as a preprocessor for more advanced code manipulation
    tools. Note that the input to any of the ds... functions should be produced
    from a TH quote, using the syntax [| ... |]. If the input to these functions
    is a hand-coded TH syntax tree, the results may be unpredictable. In
    particular, it is likely that promoted datatypes will not work as expected.

category:             Template Haskell
abi:                  f0eafa6bb8e5685947b46045b2e48611
exposed:              True
exposed-modules:
    Language.Haskell.TH.Desugar Language.Haskell.TH.Desugar.Expand
    Language.Haskell.TH.Desugar.Lift Language.Haskell.TH.Desugar.OMap
    Language.Haskell.TH.Desugar.OMap.Strict
    Language.Haskell.TH.Desugar.OSet Language.Haskell.TH.Desugar.Subst
    Language.Haskell.TH.Desugar.Sweeten

hidden-modules:
    Language.Haskell.TH.Desugar.AST Language.Haskell.TH.Desugar.Core
    Language.Haskell.TH.Desugar.FV Language.Haskell.TH.Desugar.Match
    Language.Haskell.TH.Desugar.Reify Language.Haskell.TH.Desugar.Util

import-dirs:          /usr/lib/ghc-8.10.5/site-local/th-desugar-1.12
library-dirs:         /usr/lib/ghc-8.10.5/site-local/th-desugar-1.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/th-desugar-1.12
hs-libraries:         HSth-desugar-1.12-8qbkewjc8FP5ZJRMpkEsgj
depends:
    base-4.14.2.0 containers-0.6.4.1 ghc-prim-0.6.1 mtl-2.2.2
    ordered-containers-0.2.2-4hDEgxfiDLqBjZHb5VUNDJ
    syb-0.7.2.1-5ZaH2aS3V5s5i5LSCPBZnH template-haskell-2.16.0.0
    th-abstraction-0.4.2.0-5X2XqBZ7rCLBwJXut5dQBZ
    th-lift-0.8.2-A94jWiBJfaQF1v2Vq9YgsH
    th-orphans-0.13.11-INhfnxI4KTU1yw99rFpxbn
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk

haddock-interfaces:   /usr/share/doc/haskell-th-desugar/html/th-desugar.haddock
haddock-html:         /usr/share/doc/haskell-th-desugar/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

