#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-utils
version:              1.6.0
visibility:           public
id:                   tamarin-prover-utils-1.6.0-FratIGYKPoOIPQwIoDHTpK
key:                  tamarin-prover-utils-1.6.0-FratIGYKPoOIPQwIoDHTpK
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  441c17d6e9b1853390f521393073fbca
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.Ignore Extension.Data.Bounded Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-8.10.5/site-local/tamarin-prover-utils-1.6.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/tamarin-prover-utils-1.6.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/tamarin-prover-utils-1.6.0
hs-libraries:         HStamarin-prover-utils-1.6.0-FratIGYKPoOIPQwIoDHTpK
depends:
    SHA-1.6.4.4-AdaX3b9QKHpD4bkKnWphTy base-4.14.2.0
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R binary-0.8.8.0
    blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB bytestring-0.10.12.0
    containers-0.6.4.1 deepseq-1.4.4.0 dlist-1.0-2pxhAw6JY91eMk6tw7lC2
    exceptions-0.10.4 fclabels-2.0.5.1-FSncE8vc2bkLN1piqQd8cc mtl-2.2.2
    pretty-1.1.3.6 safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    syb-0.7.2.1-5ZaH2aS3V5s5i5LSCPBZnH time-1.9.3 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

