#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-sapic
version:              1.6.0
visibility:           public
id:                   tamarin-prover-sapic-1.6.0-GIPRTSkHYCc3fnJtXu8vF
key:                  tamarin-prover-sapic-1.6.0-GIPRTSkHYCc3fnJtXu8vF
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  c25c09fe3aebc349ad2f91cc08e8b9ba
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Exceptions
    Sapic.Facts Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels

import-dirs:          /usr/lib/ghc-8.10.5/site-local/tamarin-prover-sapic-1.6.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/tamarin-prover-sapic-1.6.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/tamarin-prover-sapic-1.6.0
hs-libraries:         HStamarin-prover-sapic-1.6.0-GIPRTSkHYCc3fnJtXu8vF
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    aeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7 base-4.14.2.0
    binary-0.8.8.0 bytestring-0.10.12.0 containers-0.6.4.1
    deepseq-1.4.4.0 dlist-1.0-2pxhAw6JY91eMk6tw7lC2 exceptions-0.10.4
    fclabels-2.0.5.1-FSncE8vc2bkLN1piqQd8cc mtl-2.2.2
    parallel-3.2.2.0-H513jAs1HA11zQonYV0DH5 parsec-3.1.14.0
    process-1.6.9.0 raw-strings-qq-1.1-2uGcrrcZpyZ6SLgLGgdM5B
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    tamarin-prover-term-1.6.0-DB4BdEdIsXX70VZEcaH3Ia
    tamarin-prover-theory-1.6.0-2N6oHSPyoajKfghpEwOG1n
    tamarin-prover-utils-1.6.0-FratIGYKPoOIPQwIoDHTpK text-1.2.4.1
    transformers-0.5.6.2 uniplate-1.6.13-CG0RLAJFAqQ9pcfzpN03Lb

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

