#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 statistics
version:              0.15.2.0
visibility:           public
id:                   statistics-0.15.2.0-H7M5raggqHMLKeZ17tKUXG
key:                  statistics-0.15.2.0-H7M5raggqHMLKeZ17tKUXG
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/bos/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.

    The library'\''s facilities can be divided into four broad categories:

    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)

    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.

    * Random variate generation under several different distributions.

    * Common statistical tests for significant differences between
    samples.

category:             Math, Statistics
abi:                  e56207b5771b123c21ac094b5265d2cb
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-8.10.5/site-local/statistics-0.15.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/statistics-0.15.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/statistics-0.15.2.0
hs-libraries:         HSstatistics-0.15.2.0-H7M5raggqHMLKeZ17tKUXG
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    base-orphans-0.8.4-B4zsXTdczgN9mmNUwgnmE3 binary-0.8.8.0
    data-default-class-0.1.2.0-9cFfQKP7sucLLfD3ZZyiPI deepseq-1.4.4.0
    dense-linear-algebra-0.1.0.0-HdTYFVyF6B441XPvRkWT4r
    math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
    monad-par-0.3.5-DSmXtL6WOkxJlLEjqdCKvP
    mwc-random-0.15.0.1-8r43Rs0U6F1Ff5vg7r03B
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    vector-algorithms-0.8.0.4-GSRV1vcWImIKJgDJUF2vHE
    vector-binary-instances-0.2.5.2-5fEBRlLrHbJIGSRNZhKDtf
    vector-th-unbox-0.2.1.9-HFgXxwQTzmCEKK4EZI5O6q

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

