#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-core
version:              1.0.4.2
visibility:           public
id:                   snap-core-1.0.4.2-6KEIPSLim5uiNjZTqwJIx
key:                  snap-core-1.0.4.2-6KEIPSLim5uiNjZTqwJIx
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  0a93263ec15fa08d131f1d44ac337900
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing Snap.Test
    Snap.Types.Headers Snap.Util.CORS Snap.Util.FileServe
    Snap.Util.FileUploads Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileServe Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-8.10.5/site-local/snap-core-1.0.4.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/snap-core-1.0.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/snap-core-1.0.4.2
hs-libraries:         HSsnap-core-1.0.4.2-6KEIPSLim5uiNjZTqwJIx
depends:
    HUnit-1.6.2.0-8FsjWfKzSV74wDnwnuEJe4
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB containers-0.6.4.1
    directory-1.3.6.0 filepath-1.4.2.1
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    io-streams-1.5.2.1-FqhAw5DaL3n9TnjsO4t6Wn
    lifted-base-0.2.3.12-HsHHuUVdYcr6iiSvL0hwyv
    monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    network-uri-2.6.4.1-4m8gp52oIfHLdE9VhQrWxs
    old-locale-1.0.0.7-L6Wsx5CTYHFJNpULKIS1yv
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu
    readable-0.3.1-7NluAS2Wpy84QgsjjUKXEz
    regex-posix-0.96.0.0-7OJz5NVRWC8Iss6JoaXwme text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    transformers-base-0.4.5.2-KzHjyAKDkdpHt6juu1Rjxn
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

