#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semigroupoids
version:              5.3.5
visibility:           public
id:                   semigroupoids-5.3.5-CXCAmgAqO2AH1F4bh8bCjo
key:                  semigroupoids-5.3.5-CXCAmgAqO2AH1F4bh8bCjo
license:              BSD-3-Clause
copyright:            Copyright (C) 2011-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/semigroupoids
synopsis:             Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.

    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.

    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.

    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.

    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.

    Ideally the following relationships would hold:

    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >

    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.

    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.

    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.

category:             Control, Comonads
abi:                  10bd424bf8f32871539a9a442a1ffa58
exposed:              True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances

import-dirs:          /usr/lib/ghc-8.10.5/site-local/semigroupoids-5.3.5
library-dirs:         /usr/lib/ghc-8.10.5/site-local/semigroupoids-5.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/semigroupoids-5.3.5
hs-libraries:         HSsemigroupoids-5.3.5-CXCAmgAqO2AH1F4bh8bCjo
depends:
    base-4.14.2.0 base-orphans-0.8.4-B4zsXTdczgN9mmNUwgnmE3
    bifunctors-5.5.11-5WHPU2oStxP1cNabXCzf9E
    comonad-5.0.8-3VlYiILWTa24txTyM8uxMS containers-0.6.4.1
    contravariant-1.5.3-KWoYE9wiUjmElzHNq2wj10
    distributive-0.6.2.1-6MQhqQv9qsK3Nta0Xf3c3I
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV template-haskell-2.16.0.0
    transformers-0.5.6.2
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya

haddock-interfaces:
    /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock

haddock-html:         /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

