#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2
visibility:           public
id:                   semialign-1.2-DVaJvhv6RFh78Zehoi9eAW
key:                  semialign-1.2-DVaJvhv6RFh78Zehoi9eAW
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  840e489678b611f6a2f66110abe4c09c
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/semialign-1.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/semialign-1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/semialign-1.2
hs-libraries:         HSsemialign-1.2-DVaJvhv6RFh78Zehoi9eAW
depends:
    base-4.14.2.0 containers-0.6.4.1
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    indexed-traversable-instances-0.1-KPzocigQx9V6wBbVAxZUxQ
    semigroupoids-5.3.5-CXCAmgAqO2AH1F4bh8bCjo
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV
    these-1.1.1.1-JbK2EDkrFun4BBv3Tu20Mh transformers-0.5.6.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

