#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.12
visibility:           public
id:                   scotty-0.12-K9tWaoCm6U92UHlIQYYCS7
key:                  scotty-0.12-K9tWaoCm6U92UHlIQYYCS7
license:              BSD-3-Clause
copyright:            (c) 2012-Present Andrew Farmer
maintainer:           Andrew Farmer <xichekolas@gmail.com>
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    import Data.Monoid (mconcat)

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- param &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  16e593a1fc4a0af057e92ce821797674
exposed:              True
exposed-modules:      Web.Scotty Web.Scotty.Internal.Types Web.Scotty.Trans
hidden-modules:       Web.Scotty.Action Web.Scotty.Route Web.Scotty.Util
import-dirs:          /usr/lib/ghc-8.10.5/site-local/scotty-0.12
library-dirs:         /usr/lib/ghc-8.10.5/site-local/scotty-0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/scotty-0.12
hs-libraries:         HSscotty-0.12-K9tWaoCm6U92UHlIQYYCS7
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    base-compat-batteries-0.11.2-Adi2U3TFDt9D7s2pHONdZC
    blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB
    data-default-class-0.1.2.0-9cFfQKP7sucLLfD3ZZyiPI exceptions-0.10.4
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    regex-compat-0.95.2.1-Go1uCLOxvzSI9Xd7tyszIC text-1.2.4.1
    transformers-0.5.6.2
    transformers-base-0.4.5.2-KzHjyAKDkdpHt6juu1Rjxn
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk
    wai-3.2.3-6NrdunSiuKK6vnccK2cwty
    wai-extra-3.1.6-FKz4MHJx3sl2f6Nl0w7kAe
    warp-3.3.16-JCGQXtllRgYC0aGKpmQh8V

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

