#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 retrie
version:              0.1.1.1
visibility:           public
id:                   retrie-0.1.1.1-D5IU5pYNOYi2jNPU304BuZ
key:                  retrie-0.1.1.1-D5IU5pYNOYi2jNPU304BuZ
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  4bcf970151504b95f70cd7d535214dbc
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.ExactPrint Retrie.ExactPrint.Annotated Retrie.Expr
    Retrie.Fixity Retrie.FreeVars Retrie.GHC Retrie.GroundTerms
    Retrie.Monad Retrie.Options Retrie.PatternMap.Bag
    Retrie.PatternMap.Class Retrie.PatternMap.Instances Retrie.Pretty
    Retrie.Quantifiers Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Rules
    Retrie.Rewrites.Types Retrie.Run Retrie.SYB Retrie.Subst
    Retrie.Substitution Retrie.Types Retrie.Universe Retrie.Util

import-dirs:          /usr/lib/ghc-8.10.5/site-local/retrie-0.1.1.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/retrie-0.1.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/retrie-0.1.1.1
hs-libraries:         HSretrie-0.1.1.1-D5IU5pYNOYi2jNPU304BuZ
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX directory-1.3.6.0
    filepath-1.4.2.1 ghc-8.10.5
    ghc-exactprint-0.6.4-HTJ2iHb4k1m4hsudMcg3aJ mtl-2.2.2
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    process-1.6.9.0 random-shuffle-0.0.4-11ILuJIRt6oLGFZKWckj8N
    syb-0.7.2.1-5ZaH2aS3V5s5i5LSCPBZnH text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

