#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 parameterized-utils
version:              2.1.3.0
visibility:           public
id:                   parameterized-utils-2.1.3.0-BIOjMQUv8gCIo20O8QqI59
key:                  parameterized-utils-2.1.3.0-BIOjMQUv8gCIo20O8QqI59
license:              BSD-3-Clause
copyright:            ©2016-2021 Galois, Inc.
maintainer:           jhendrix@galois.com, kquick@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  3921b543fde8b5db8345ad2acee3884c
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/parameterized-utils-2.1.3.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/parameterized-utils-2.1.3.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/parameterized-utils-2.1.3.0

hs-libraries:         HSparameterized-utils-2.1.3.0-BIOjMQUv8gCIo20O8QqI59
depends:
    base-4.14.2.0 base-orphans-0.8.4-B4zsXTdczgN9mmNUwgnmE3
    constraints-0.13-AnR9rNxGX5VB941qwyLpm4 containers-0.6.4.1
    deepseq-1.4.4.0 ghc-prim-0.6.1
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    hashtables-1.2.4.1-43zoxjuV2LAL5nNA3NSXHl
    lens-5.0.1-9j09gzxg2dR5Wmd3U39g28 mtl-2.2.2
    template-haskell-2.16.0.0 text-1.2.4.1
    th-abstraction-0.4.2.0-5X2XqBZ7rCLBwJXut5dQBZ
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

